// File from page 725 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT02.ZIP 4/11/95
// (Original ECKELT01.ZIP dated 2/21/95)
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: RTSHAPES.CPP -- Counting shapes
#include <iostream.h>
#include <time.h>
#include <typeinfo.h>
#include "..\14\tstash.h"

class shape {
protected:
  static int count;
public:
  shape() { count++; }
  virtual ~shape() = 0 { count--; }
  virtual void draw() const = 0;
  static int quantity() { return count; }
};

int shape::count = 0;

class rectangle : public shape {
  void operator=(rectangle&); // Disallow
protected:
  static int count;
public:
  rectangle() { count++; }
  rectangle(const rectangle&) { count++;}
  ~rectangle() { count--; }
  void draw() const {
    cout << "rectangle::draw()" << endl;
  }
  static int quantity() { return count; }
};

int rectangle::count = 0;

class ellipse : public shape {
  void operator=(ellipse&); // Disallow
protected:
  static int count;
public:
  ellipse() { count++; }
  ellipse(const ellipse&) { count++; }
  ~ellipse() { count--; }
  void draw() const {
    cout << "ellipse::draw()" << endl;
  }
  static int quantity() { return count; }
};

int ellipse::count = 0;

class circle : public ellipse {
  void operator=(circle&); // Disallow
protected:
  static int count;
public:
  circle() { count++; }
  circle(const circle&) { count++; }
  ~circle() { count--; }
  void draw() const {
    cout << "circle::draw()" << endl;
  }
  static int quantity() { return count; }
};

int circle::count = 0;

main() {
  tstash<shape> shapes;
  time_t t;
  // Seed random number generator:
  srand((unsigned)time(&t));
  const mod = 12;
  for(int i = 0; i < rand() % mod; i++)
    shapes.add(new rectangle);
  for(int j = 0; j < rand() % mod; j++)
    shapes.add(new ellipse);
  for(int k = 0; k < rand() % mod; k++)
    shapes.add(new circle);
  int Ncircles = 0;
  int Nellipses = 0;
  int Nrects = 0;
  int Nshapes = 0;
  for(int u = 0; u < shapes.count(); u++) {
    shapes[u]->draw();
    if(dynamic_cast<circle*>(shapes[u]))
      Ncircles++;
    if(dynamic_cast<ellipse*>(shapes[u]))
      Nellipses++;
    if(dynamic_cast<rectangle*>(shapes[u]))
      Nrects++;
    if(dynamic_cast<shape*>(shapes[u]))
      Nshapes++;
  }
  cout << endl << endl
       << "circles = " << Ncircles << endl
       << "ellipses = " << Nellipses << endl
       << "rectangles = " << Nrects << endl
       << "shapes = " << Nshapes << endl
       << endl
       << "circle::quantity() = "
       << circle::quantity() << endl
       << "ellipse::quantity() = "
       << ellipse::quantity() << endl
       << "rectangle::quantity() = "
       << rectangle::quantity() << endl
       << "shape::quantity() = "
       << shape::quantity() << endl;
}
