; File......: FLUSHCAP.ASM
; Author....: James R. Zack
; CIS ID....: 75410,1567
; Date......: $Date:   15 Aug 1991 23:06:46  $
; Revision..: $Revision:   1.2  $
; Log File..: $Logfile:   E:/nanfor/src/flushcap.asv  $
;
; This is an original work by James R. Zack and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   E:/nanfor/src/flushcap.asv  $
;  
;     Rev 1.2   15 Aug 1991 23:06:46   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   14 Jun 1991 19:54:32   GLENN
;  Minor edit to file header
;  
;     Rev 1.0   01 Apr 1991 01:03:20   GLENN
;  Nanforum Toolkit
;  
;


; $DOC$
; $FUNCNAME$
;     FT_PFLUSH()
; $CATEGORY$
;     NetWare
; $ONELINER$
;     Flush a NetWare capture buffer
; $SYNTAX$
;     FT_PFLUSH( [ <nLPTPortNumber> ] ) -> NIL
; $ARGUMENTS$
;     <nLPTPortNumber> is the captured LPT port number to flush.  If the
;     parameter is omitted, the default port or LPT1: is used.
; $RETURNS$
;     NIL
; $DESCRIPTION$
;    This routine is used to force a Novell NetWare capture buffer to print
;    it's contents.  This is useful for printing reports with a filter set
;    and you don't know how long it will be between print statements.  With
;    a FT_PFLUSH() function at the end of any printing, you can have the
;    timeout value for any capture set to 0 (zero).
;
;    This routine was designed and written for Advanced NetWare 286 v 2.0 or
;    NetWare 386 v 3.0 or better.  It has been tested on Advanced NetWare 286
;    v 2.15 rev A & C, NetWare 386 v 3.0.
;
;    This source code was written for Microsoft Macro Assembler v5.1.
; $EXAMPLES$
;    (in DOS)
;    F:>CAPTURE S=ServerName Q=PrintQueueName TI=0 L=1
;
;    (in your Clipper application)
;    SET FILTER TO Left( FONELIST->PHONENUM, 3 ) == "415"
;    GO TOP
;    SET PRINT ON
;    DO WHILE .NOT. Eof()
;      ? fonelist->lastname...
;      SKIP
;    ENDDO
;    FT_PFLUSH(1)     && I could just say FT_PFLUSH() here as well.
; $END$


PUBLIC   FT_PFLUSH                         ; MAKE FUNCTION VISIBLE

EXTRN    __PARNI:FAR                       ; DECLARE EXTERNALS
EXTRN    __RET:FAR

_NANFOR  SEGMENT 'CODE'
         ASSUME  CS:_NANFOR
FT_PFLUSH PROC    FAR
          PUSH    BP                        ; SAVE BASE POINTER
          MOV     BP,SP                     ; POINT TO TOP OF STACK
          PUSH    DS                        ; SAVE REGISTERS
          PUSH    ES
          PUSH    SI
          PUSH    DI
          MOV     AX,01                     ; POINT TO FIRST PARAM PASSED
          PUSH    AX                        ; PUSH IT ONTO STACK FOR PARNI
          CALL    __PARNI                   ; GO GET FIRST PARAM
          ADD     SP,2                      ; RESET STACK AFTER PARNI
          CMP     AX,00                     ; WAS A VALUE PASSED?
          JE      PSELECT                   ; NO, ASSUME LPT1:
          DEC     AX                        ; SUBTRACT 1 FROM PRINTER NUMBER

; THE REASON FOR DEDUCTING 1 FROM THE PRINTER NUMBER PASSED IS THAT NOVELL
; ASSUMES PRINTERS AS FOLLOWS:  PORT NUMBER  == PORT NAME
;                               -----------     ---------
;                                   0        ==   LPT1:
;                                   1        ==   LPT2:
;                                   2        ==   LPT3:

PSELECT:  MOV     DH,AL                     ; SET PRINTER PORT NUMBER INTO DH
          MOV     AH,0DFH                   ; AH == FUNCTION DFH
          MOV     DL,07H                    ; DL == SUBFUNCTION 07H
          INT     21H                       ; CALL (Flush Specific LPT Capture)
          pop     di                        ; Restore registers
          pop     si
          pop     es
          pop     ds
          pop     bp
          call    __RET                     ; Set up for return to Clipper
          ret                               ; Pass control back to Clipper
FT_PFLUSH ENDP
_NanFor   ENDS
          END


