; File......: DISPCNT.ASM
; Author....: Ted Means
; CIS ID....: 73067,3332
; Date......: $Date:   17 Oct 1992 16:26:56  $
; Revision..: $Revision:   1.1  $
; Log file..: $Logfile:   C:/nanfor/src/dispcnt.asv  $
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   C:/nanfor/src/dispcnt.asv  $
;  
;     Rev 1.1   17 Oct 1992 16:26:56   GLENN
;  Leo cleaned up documentation block.
;  
;     Rev 1.0   15 Oct 1992 23:57:46   GLENN
;  Initial revision.
; 

;  $DOC$
;  $FUNCNAME$
;     FT_DispCnt()
;  $CATEGORY$
;     Video
;  $ONELINER$
;     Return the number of outstanding calls to DispBegin()
;  $SYNTAX$
;     FT_DispCnt() --> nCount
;  $ARGUMENTS$
;     None
;  $RETURNS$
;     An integer.
;  $DESCRIPTION$
;     Some routines (like exception handlers, for example) must be able to
;     guarantee that their output makes it to the screen.  This can be
;     difficult if a call to DispBegin() is in effect, because any error
;     messages will be sent to Clipper's virtual screen buffer instead of
;     the actual physical screen.  This function alleviates the problem by
;     allowing you to determine if screen output is being buffered, and if
;     so, how many DispEnd() calls are necessary to flush the buffer.
;
;     Although this function does not use "internals" in the conventional
;     sense, it still makes use of version-specific information in order
;     to locate the virtual screen buffer.  DO NOT attempt to use this
;     function with any version of Clipper other than 5.01.
;  $EXAMPLES$
;
;     function ErrorHandler()
;
;     // Guarantee that the error message will reach the screen
;
;     while FT_DispCnt() > 0 ; dispend(); end
;
;     // Now it's okay to do the error message
;
;     ErrorMessage( "Something terrible has happened" )
;
;     return NIL
;
;  $END$
;

IDEAL                                        ; Invoke TASM IDEAL mode

Public   FT_DispCnt

Extrn    DispEnd:Far
Extrn    __RetNI:Far

Segment  _NanFor   Word      Public    "CODE"
         Assume    CS:_NanFor

Proc     FT_DispCnt          Far

         Mov       BX,Seg DispEnd            ; Get segment of DispEnd()
         Mov       ES,BX                     ; Store in ES
         Mov       BX,Offset DispEnd         ; Get offset of DispEnd()
         Mov       BX,[Word Ptr ES:BX + 6]   ; Lift address from machine code
         LES       BX,[DWord Ptr BX]         ; Load pointer into ES:BX
         Mov       AX,[Word Ptr ES:BX + 2Eh] ; Grab current count
         Neg       AX                        ; It's stored as a negative
         Push      AX                        ; Put on stack
         Call      __RetNI                   ; Return it
         Add       SP,2                      ; Realign stack
         RetF

Endp     FT_DispCnt
Ends     _NanFor
End

