/*
 * File......: ALT.C
 * Author....: Ted Means
 * Date......: $Date:   15 Aug 1991 23:08:34  $
 * Revision..: $Revision:   1.2  $
 * Log file..: $Logfile:   E:/nanfor/src/alt.c_v  $
 * 
 * This function is an original work by Ted Means and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:   E:/nanfor/src/alt.c_v  $
 * 
 *    Rev 1.2   15 Aug 1991 23:08:34   GLENN
 * Forest Belt proofread/edited/cleaned up doc
 * 
 *    Rev 1.1   14 Jun 1991 19:53:36   GLENN
 * Minor edit to file header
 * 
 *    Rev 1.0   01 Apr 1991 01:02:42   GLENN
 * Nanforum Toolkit
 * 
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FT_ALT()
 *  $CATEGORY$
 *     Keyboard/Mouse
 *  $ONELINER$
 *     Determine status of the Alt key
 *  $SYNTAX$
 *     FT_ALT() -> lValue
 *  $ARGUMENTS$
 *     None
 *  $RETURNS$
 *     .T. if Alt key is pressed, .F. if otherwise.
 *  $DESCRIPTION$
 *     This function is useful for times you need to know whether or not the
 *     Alt key is pressed, such as during a MemoEdit().
 *  $EXAMPLES$
 *     IF FT_ALT()
 *        @24, 0 say "Alt"
 *     ELSE
 *        @24, 0 say "   "
 *     ENDIF
 *  $SEEALSO$
 *     FT_CAPLOCK() FT_CTRL() FT_NUMLOCK() FT_PRTSCR() FT_SHIFT()
 *  $END$
 */

#include <extend.h>

CLIPPER FT_ALT(void)
{
   _retl( (int) ((*(char *) 0x00000417) & 0x8) );
   return;
}
