* Program: SumOfRec.prg
* Author:  Grant Nesheim
* Version: Clipper Summer '87
* Note(s): Perform the sum of reciprocals test using four
*          methods for comparing the results to determine
*          which method is best.
*
* Copyright (c) 1988 Nantucket Corp.

CLEAR
@ 1,0 SAY "Sum of reciprocals with various comparison methods."
@ 3,0 SAY " A - sum == 1.00"
@ 4,0 SAY " B - ABS(sum-1.00) < epsilon  (epsilon = 10^-15)"
@ 5,0 SAY " C - ROUND(sum,2) = 1.00"
@ 6,0 SAY " D - VAL(STR(sum,4,2)) = 1.00"
@ 8,0 SAY " N     Sum   A   B   C   D"
@ 9,0 SAY " -------------------------"

epsilon = 10^-15
FOR i = 1.00 TO 15.00
   sum = 0.00
   FOR j = 1.00 TO i
      sum = sum + 1/i
   NEXT

   * Use the straight forward method for testing equality.
   a = IF(sum == 1.00,"T","F")

   * Use the machine epsilon to method to test equality.
   b = IF(ABS(sum-1.00) < epsilon,"T","F")

   * Use ROUND() to test for equality.
   c = IF(ROUND(sum,2) == 1.00,"T","F")

   * Use the string function to test for equality.
   d = IF(VAL(STR(sum,4,2)) == 1.00,"T","F")

   @ 9+INT(i), 0 SAY STR(i,5,2)+" "+STR(sum,4,2)
   @ 9+INT(i), 13 SAY a + "   " + b + "   " + c + "   " + d
NEXT
RETURN
