Version 1.00
BEGIN Form frmIdealGas
	AutoRedraw   = 0
	BackColor    = QBColor(7)
	BorderStyle  = 2
	Caption      = "Ideal Gas: PV = nRT"
	ControlBox   = -1
	Enabled      = -1
	ForeColor    = QBColor(0)
	Height       = Char(8)
	Left         = Char(0)
	MaxButton    = -1
	MinButton    = -1
	MousePointer = 0
	Tag          = ""
	Top          = Char(6)
	Visible      = 0
	Width        = Char(79)
	WindowState  = 0
	BEGIN ComboBox cboVolumeUnit
		BackColor    = QBColor(7)
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(1)
		Height       = Char(1)
		Left         = Char(10)
		MousePointer = 0
		Sorted       = 0
		Style        = 2
		TabIndex     = 17
		TabStop      = -1
		Tag          = ""
		Top          = Char(5)
		Visible      = -1
		Width        = Char(6)
	END
	BEGIN Label lblPressure
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "pr&essure:"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(1)
		Height       = Char(1)
		Left         = Char(20)
		MousePointer = 0
		TabIndex     = 18
		Tag          = ""
		Top          = Char(5)
		Visible      = -1
		Width        = Char(9)
	END
	BEGIN ComboBox cboPressureUnit
		BackColor    = QBColor(7)
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(1)
		Height       = Char(1)
		Left         = Char(31)
		MousePointer = 0
		Sorted       = 0
		Style        = 2
		TabIndex     = 19
		TabStop      = -1
		Tag          = "3"
		Top          = Char(5)
		Visible      = -1
		Width        = Char(10)
	END
	BEGIN Label lblTemp
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "temper&ature:"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(1)
		Height       = Char(1)
		Left         = Char(45)
		MousePointer = 0
		TabIndex     = 20
		Tag          = ""
		Top          = Char(5)
		Visible      = -1
		Width        = Char(12)
	END
	BEGIN ComboBox cboTempUnit
		BackColor    = QBColor(7)
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(1)
		Height       = Char(1)
		Left         = Char(59)
		MousePointer = 0
		Sorted       = 0
		Style        = 2
		TabIndex     = 21
		TabStop      = -1
		Tag          = ""
		Top          = Char(5)
		Visible      = -1
		Width        = Char(6)
	END
	BEGIN CommandButton cmdSize
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "&Size"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(2)
		Left         = Char(1)
		MousePointer = 0
		TabIndex     = 22
		TabStop      = -1
		Tag          = "2"
		Top          = Char(3)
		Visible      = -1
		Width        = Char(6)
	END
	BEGIN CommandButton cmdResetR
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "R&eset R"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(2)
		Left         = Char(8)
		MousePointer = 0
		TabIndex     = 23
		TabStop      = -1
		Tag          = ""
		Top          = Char(3)
		Visible      = 0
		Width        = Char(11)
	END
	BEGIN Label lblEqualSign
		Alignment    = 2
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "="
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(18)
		MousePointer = 0
		TabIndex     = 26
		Tag          = ""
		Top          = Char(2)
		Visible      = -1
		Width        = Char(1)
	END
	BEGIN Label lblXT1
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "X"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(38)
		MousePointer = 0
		TabIndex     = 27
		Tag          = ""
		Top          = Char(1)
		Visible      = -1
		Width        = Char(1)
	END
	BEGIN Label lblDivisionLine
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(20)
		MousePointer = 0
		TabIndex     = 28
		Tag          = ""
		Top          = Char(2)
		Visible      = -1
		Width        = Char(57)
	END
	BEGIN Label lblVariable
		Alignment    = 2
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "&P, atm"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 36
		Left         = Char(0)
		MousePointer = 0
		TabIndex     = 0
		Tag          = "0"
		Top          = Char(1)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN Label lblVariable
		Alignment    = 2
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "&V, L"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 34
		Left         = Char(20)
		MousePointer = 0
		TabIndex     = 4
		Tag          = "4"
		Top          = Char(4)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN Label lblVariable
		Alignment    = 2
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "&R, L atm/mol/K"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 38
		Left         = Char(40)
		MousePointer = 0
		TabIndex     = 2
		Tag          = "2"
		Top          = Char(0)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN Label lblVariable
		Alignment    = 2
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "&T, C"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 37
		Left         = Char(60)
		MousePointer = 0
		TabIndex     = 6
		Tag          = "3"
		Top          = Char(0)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN Label lblVariable
		Alignment    = 2
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "&n, moles"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 35
		Left         = Char(20)
		MousePointer = 0
		TabIndex     = 8
		Tag          = "1"
		Top          = Char(0)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN TextBox txtVariable
		BackColor    = QBColor(7)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 36
		Left         = Char(0)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 1
		TabStop      = -1
		Tag          = "pressure"
		Text         = ""
		Top          = Char(2)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN TextBox txtVariable
		BackColor    = QBColor(7)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(9)
		Height       = Char(1)
		Index        = 38
		Left         = Char(40)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 3
		TabStop      = -1
		Tag          = "R"
		Text         = "8.314510"
		Top          = Char(1)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN TextBox txtVariable
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 34
		Left         = Char(20)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 5
		TabStop      = -1
		Tag          = "volume"
		Text         = ""
		Top          = Char(3)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN TextBox txtVariable
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 37
		Left         = Char(60)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 7
		TabStop      = -1
		Tag          = "temperature"
		Text         = ""
		Top          = Char(1)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN TextBox txtVariable
		BackColor    = QBColor(14)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 35
		Left         = Char(20)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 9
		TabStop      = -1
		Tag          = "amount"
		Text         = ""
		Top          = Char(1)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN Label lblDragDrop
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(8)
		BorderStyle  = 0
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(2)
		Height       = Char(1)
		Left         = Char(0)
		MousePointer = 0
		TabIndex     = 10
		Tag          = ""
		Top          = Char(0)
		Visible      = 0
		Width        = Char(17)
	END
	BEGIN OptionButton optDependent
		BackColor    = QBColor(7)
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 35
		Left         = Char(18)
		MousePointer = 0
		TabIndex     = 13
		TabStop      = 0
		Tag          = ""
		Top          = Char(2)
		Value        = 0
		Visible      = 0
		Width        = Char(3)
	END
	BEGIN OptionButton optDependent
		BackColor    = QBColor(7)
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 38
		Left         = Char(18)
		MousePointer = 0
		TabIndex     = 14
		TabStop      = 0
		Tag          = ""
		Top          = Char(3)
		Value        = 0
		Visible      = 0
		Width        = Char(3)
	END
	BEGIN OptionButton optDependent
		BackColor    = QBColor(7)
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 37
		Left         = Char(18)
		MousePointer = 0
		TabIndex     = 15
		TabStop      = 0
		Tag          = ""
		Top          = Char(4)
		Value        = 0
		Visible      = 0
		Width        = Char(3)
	END
	BEGIN OptionButton optDependent
		BackColor    = QBColor(7)
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 34
		Left         = Char(18)
		MousePointer = 0
		TabIndex     = 12
		TabStop      = 0
		Tag          = ""
		Top          = Char(1)
		Value        = 0
		Visible      = 0
		Width        = Char(3)
	END
	BEGIN OptionButton optDependent
		BackColor    = QBColor(7)
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(3)
		Height       = Char(1)
		Index        = 36
		Left         = Char(18)
		MousePointer = 0
		TabIndex     = 11
		TabStop      = -1
		Tag          = ""
		Top          = Char(0)
		Value        = -1
		Visible      = 0
		Width        = Char(3)
	END
	BEGIN Label lblVolume
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "v&olume:"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(1)
		Height       = Char(1)
		Left         = Char(1)
		MousePointer = 0
		TabIndex     = 16
		Tag          = ""
		Top          = Char(5)
		Visible      = -1
		Width        = Char(7)
	END
	BEGIN Label lblXB1
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "X"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(38)
		MousePointer = 0
		TabIndex     = 25
		Tag          = ""
		Top          = Char(3)
		Visible      = 0
		Width        = Char(1)
	END
	BEGIN Label lblXT2
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "X"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(58)
		MousePointer = 0
		TabIndex     = 24
		Tag          = ""
		Top          = Char(1)
		Visible      = -1
		Width        = Char(1)
	END
END
DECLARE SUB Initialize_mnUnits (BYVAL nvGroup%)
' Updated:  October, 1996 by Christopher King
'
' ------------------------------------------------------------------------
'               Copyright (C) 1996 by Christopher King
'
' You have a royalty-free right to use, modify, reproduce and distribute
' the OneOhOne Files (and/or any modified version) in any way you find
' useful, provided that you agree that Christopher King has no warranty,
' obligations or liability for any OneOhOne Files.
' ------------------------------------------------------------------------
DECLARE SUB ShowXs (BYVAL nvGroup%, SourceForm AS FORM)
DECLARE SUB InfoShow (LastControl AS CONTROL, BYVAL svInfo AS STRING, BYVAL nvColor%)
DECLARE SUB RConvert (bReset%)
DECLARE SUB Form_DragDrop (Source AS CONTROL, X AS SINGLE, Y AS SINGLE)
DECLARE SUB optDependent_Click (Index AS INTEGER)
DECLARE SUB txtVariable_GotFocus (Index AS INTEGER)
DECLARE SUB CalculateFormula (BYVAL Index%)
DECLARE SUB ChangePressureUnit (BYVAL nvGroup%, Source AS FORM)
DECLARE SUB ChangeTempUnit (BYVAL nvGroup%, Source AS FORM)
DECLARE SUB InterpretKeyPress (BYVAL Index%, KeyAscii%, nvGroup%, CallingForm AS FORM)
DECLARE SUB ChangeVolumeUnit (BYVAL nvGroup%, Source AS FORM)
DECLARE SUB DragDrop4 (Source AS CONTROL, X AS SINGLE, Y AS SINGLE, BYVAL sSize AS STRING, BYVAL nvGroup%, Target AS FORM)
DECLARE SUB FormPositionClear (BYVAL nvGroup%)
DECLARE SUB SizeForm (BYVAL svSizeStatus AS STRING, BYVAL nvGroup%, CallingForm AS FORM)
DECLARE FUNCTION nOptionButton (Index%, BYVAL nvGroup%, CallingForm AS FORM) AS INTEGER
DECLARE SUB GeneralLostFocus (BYVAL Index%, BYVAL nvGroup%, CallingForm AS FORM)
DECLARE FUNCTION nSetNextFocus (BYVAL nvIndex%) AS INTEGER
'$FORM frmMDI
DEFINT A-Z
OPTION EXPLICIT
'$INCLUDE: 'common.bi'
DIM SHARED mbFormLoading AS INTEGER

CONST BRIGHT_WHITE = 15
CONST YELLOW = 14

' Change pressure units.
'
SUB cboPressureUnit_Click ()
DIM N
   ChangePressureUnit 8, frmIdealGas
   RConvert 0
   ' Called when form loads.  The setfocus below doesn't work then.
   IF NOT mbFormLoading THEN
      N = nSetNextFocus(gOccupantIndex(8, 1))
   END IF
END SUB

SUB cboTempUnit_Click ()
DIM N
   ChangeTempUnit 8, frmIdealGas
   IF NOT mbFormLoading THEN
      N = nSetNextFocus(gOccupantIndex(8, 1))
   END IF
END SUB

' Change volume units
'
SUB cboVolumeUnit_Click ()
DIM N
   ChangeVolumeUnit 8, frmIdealGas
   RConvert 0
   ' Called when form loads.  The setfocus below doesn't work then.
   IF NOT mbFormLoading THEN
      N = nSetNextFocus(gOccupantIndex(8, 1))
   END IF
END SUB

SUB cboVolumeUnit_DragDrop (Source AS CONTROL, X AS SINGLE, Y AS SINGLE)
   Form_DragDrop Source, CSNG(cboVolumeUnit.Left), CSNG(cboVolumeUnit.Top)
END SUB

' Allows user to reset a calculated value of R to the accepted value.
'
SUB cmdResetR_Click ()
   RConvert 1
   CalculateFormula gOccupantIndex(8, 0)
   cmdResetR.Visible = FALSE
END SUB

' Change the size of the frame and placement of controls in frame.
SUB cmdSize_Click ()
SizeForm cmdSize.Tag, 8, frmIdealGas
END SUB

SUB Form_DragDrop (Source AS CONTROL, X AS SINGLE, Y AS SINGLE)
   DragDrop4 Source, X, Y, cmdSize.Tag, 8, frmIdealGas
END SUB

DEFSNG A-Z
SUB Form_Load ()
DIM N
   gOccupantIndex(8, 0) = 36
   gOccupantIndex(8, 1) = 35
   gOccupantIndex(8, 2) = 38
   gOccupantIndex(8, 3) = 37
   gOccupantIndex(8, 4) = 34
   gOccupantIndex(8, 5) = -1
   gOccupantIndex(8, 6) = -1
   gbDontStopHere(38) = TRUE
   gdNumber(38) = 8314.51#
   gdUncertainty(38) = .001#
   Initialize_mnUnits 8
   RConvert 1
   frmMDI.mnuWindowForm(8).CHECKED = TRUE

   mbFormLoading = TRUE  ' Used by volume unit combo box.
   cboPressureUnit.ADDITEM "pascal", 0
   cboPressureUnit.ADDITEM "kPa", 1
   cboPressureUnit.ADDITEM "bar", 2
   cboPressureUnit.ADDITEM "atm", 3
   cboPressureUnit.ADDITEM "mm Hg", 4
   cboPressureUnit.ADDITEM "torr", 5
   cboPressureUnit.ADDITEM "psi", 6
   cboPressureUnit.ListIndex = 3

   cboVolumeUnit.ADDITEM "L", 0
   cboVolumeUnit.ADDITEM "mL", 1
   cboVolumeUnit.ListIndex = 0

   cboTempUnit.ADDITEM "C", 0
   cboTempUnit.ADDITEM "K", 1
   cboTempUnit.ADDITEM "F", 2
   cboTempUnit.ListIndex = 0
   mbFormLoading = FALSE  ' Used by combo boxes.
END SUB

DEFINT A-Z
' Free the location of this form.
SUB Form_Unload (Cancel AS INTEGER)
   FormPositionClear 8
END SUB

SUB lblDragDrop_Change ()
DIM Index
   Index = VAL(frmIdealGas.Tag)
   SELECT CASE lblDragDrop.Caption
      CASE "M0"
         lblDragDrop.Tag = FORMAT$(Index) + " 8" + txtVariable(Index).Tag
         Form_DragDrop lblDragDrop, 0!, 1!
      CASE "M1"
         lblDragDrop.Tag = FORMAT$(Index) + " 8" + txtVariable(Index).Tag
         Form_DragDrop lblDragDrop, 26!, 0!
      CASE "M2"
         lblDragDrop.Tag = FORMAT$(Index) + " 8" + txtVariable(Index).Tag
         Form_DragDrop lblDragDrop, 52!, 0!
      CASE "M3"
         lblDragDrop.Tag = FORMAT$(Index) + " 8" + txtVariable(Index).Tag
         Form_DragDrop lblDragDrop, 65!, 0!
      CASE "M4"
         lblDragDrop.Tag = FORMAT$(Index) + " 8" + txtVariable(Index).Tag
         Form_DragDrop lblDragDrop, 26!, 3!
      CASE "M5"
         lblDragDrop.Tag = FORMAT$(Index) + " 8" + txtVariable(Index).Tag
         Form_DragDrop lblDragDrop, 52!, 3!
      CASE "M6"
         lblDragDrop.Tag = FORMAT$(Index) + " 8" + txtVariable(Index).Tag
         Form_DragDrop lblDragDrop, 65!, 3!
      CASE "OB"
         ' Click an option button for a different module.
         ' The tag tells which one.
         optDependent_Click (VAL(lblDragDrop.Tag))
   END SELECT
   lblDragDrop.Caption = ""
END SUB

SUB lblVariable_DragDrop (Index AS INTEGER, Source AS CONTROL, X AS SINGLE, Y AS SINGLE)
   Form_DragDrop Source, CSNG(lblVariable(Index).Left), CSNG(lblVariable(Index).Top)
END SUB

' Initiate drag.
' The label's tag is given txtGramMole's index.
SUB lblVariable_MouseDown (Index AS INTEGER, Button AS INTEGER, Shift AS INTEGER, X AS SINGLE, Y AS SINGLE)
DIM nYAdjust, nWidth, nXAdjust

' Allow only the dependent variable to be dragged when the frame is small.
IF Index <> gOccupantIndex(8, 0) AND cmdSize.Tag = "1" THEN EXIT SUB
lblDragDrop.Tag = FORMAT$(Index) + " 8" + txtVariable(Index).Tag
IF cmdSize.Tag = "1" THEN
   nXAdjust = -17
ELSE
   IF Index = gOccupantIndex(8, 4) OR Index = gOccupantIndex(8, 5) OR Index = gOccupantIndex(8, 6) THEN
      ' Bottom value is above label.
      nYAdjust = -1
   ELSE
      ' Other values are below label.
      nYAdjust = 1
   END IF
END IF
txtVariable(Index).SETFOCUS
lblDragDrop.MOVE lblVariable(Index).Left + nXAdjust, lblVariable(Index).Top + Y + nYAdjust
lblDragDrop.DRAG        ' Drag label outline
END SUB

SUB lblVolume_DragDrop (Source AS CONTROL, X AS SINGLE, Y AS SINGLE)
   Form_DragDrop Source, CSNG(lblVolume.Left), CSNG(lblVolume.Top)
END SUB

' Selects the dependent variable:  density, gram, or mL
SUB optDependent_Click (Index AS INTEGER)
DIM N

   N = nOptionButton(Index, 8, frmIdealGas)
   IF N > 34 AND N < 39 THEN
      ' I don't know why.  The SetNextFocus routine works for setting focus
      ' to other forms, but not the calling form.
      txtVariable_GotFocus N    ' Color yellow, etc.
      txtVariable(N).SETFOCUS   ' First one does nothing if already there.
   END IF
END SUB

SUB txtVariable_DragDrop (Index AS INTEGER, Source AS CONTROL, X AS SINGLE, Y AS SINGLE)
   Form_DragDrop Source, CSNG(txtVariable(Index).Left), CSNG(txtVariable(Index).Top)

END SUB

SUB txtVariable_GotFocus (Index AS INTEGER)
   IF NOT gbDontStopHere(Index) THEN
      ' NonContinuedLine indicates whether or not the selection is to be
      ' deleted by the first key pressed.
      txtVariable(Index).BackColor = YELLOW
      txtVariable(Index).SelStart = 0
      txtVariable(Index).SelLength = 19
      gsOriginalText(8) = txtVariable(Index).Text ' Save original text; recall with escape key.
   END IF
   frmIdealGas.Tag = STR$(Index)

END SUB

SUB txtVariable_KeyPress (Index AS INTEGER, KeyAscii AS INTEGER)
   InterpretKeyPress Index, KeyAscii, 8, frmIdealGas
END SUB

SUB txtVariable_LostFocus (Index AS INTEGER)
IF Index < 38 THEN
   GeneralLostFocus Index, 8, frmIdealGas
END IF
END SUB

