
/*============================================================================

	CDROM.H
	CDROM related structures and defines. Prototypes of CDROMF.C, CDROMFA.ASM.
  This file is part of the

  PseudoCD package (version 02)
  Copyright (C) C.Kulms, 1997

  This is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This software is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this software; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

============================================================================*/

#ifndef _CDROM_H_
#define _CDROM_H_

#ifndef _DRIVER_H_
	#include "driver.h"
#endif

/* cdrom driver constants */
#define LOCKDOOR		1		/* lock drive's door */
#define UNLOCKDOOR	0		/* unlock drive's door */
#define HSGADR			0		/* address is in HSG format */
#define REDBOOK			1		/* address is in Red-Book format */
#define COOKED			0		/* 'cooked' data requested */
#define RAWDATA			1		/* raw data requested */

/* IOCTL-input/output command-codes for cdrom drivers */
#define IOCTL_DRVHDR		0x0300	/* return device-driver header */
#define IOCTL_HEADLOC		0x0301	/* location of head */
#define IOCTL_ERRSTAT		0x0303	/* error statistics */
#define IOCTL_ACINFO		0x0304	/* audio channel info */
#define IOCTL_RBYTES		0x0305	/* read drive bytes */
#define IOCTL_DEVSTAT		0x0306	/* return device status */
#define IOCTL_SECSIZE		0x0307	/* return sector size */
#define IOCTL_VOLSIZE		0x0308	/* return volume size */
#define IOCTL_MEDCHG		0x0309	/* media changed */
#define IOCTL_DISKINFO	0x030A	/* audio disk info */
#define IOCTL_TRACKINFO	0x030B	/* audio track info */
#define IOCTL_QCINFO		0x030C	/* audio Q-channel info */
#define IOCTL_SCINFO		0x030D	/* audio sub-channel info */
#define IOCTL_UPC				0x030E	/* UPC code */
#define IOCTL_ASINFO		0x030F	/* audio status info */
#define IOCTL_EJECT			0x0C00	/* eject disk */
#define IOCTL_LOCK			0x0C01	/* lock/unlock door */
#define IOCTL_RESET			0x0C02	/* reset drive */
#define IOCTL_ACCTRL		0x0C03	/* audio channel control */
#define IOCTL_WBYTES		0x0C04	/* write device control string */
#define IOCTL_CLOSE			0x0C05	/* close tray */

/* commands for cdrom drivers */
#define RDLONG	0x0080	/* read long */
#define RDLONGP	0x0082	/* read long prefetch */
#define SEEK		0x0083	/* seek */
#define PLAY		0x0084	/* play audio */
#define STOP		0x0085	/* stop audio */
#define WRLONG	0x0086	/* write long */
#define WRLONGV	0x0087	/* write long verify */
#define RESUME	0x0088	/* resume audio */

typedef struct s_CDDRVHDR	/* extended device-driver header for cdrom-drivers */
{
	t_DRVHDR	tDrvHdr;	/* see file 'driver.h' */
	char		cDrive;			/* filled in by MSCDEX (has to be 0 at INIT) */
	char		cUnits;			/* number of units */
}	t_CDDRVHDR;

typedef struct s_REDBOOK
{
	char	cFrame;		/* sector address (REDBOOK) - frame (binary) */
	char	cSecond; 	/* - second (binary) */
	char	cMinute; 	/* - minute (binary) */
	char	cUnused;
}	t_REDBOOK;

typedef struct s_READL	/* extended request header for READ LONG */
{
	t_REQHDR	tReqHdr;	/* see file 'driver.h' */
	char			cAdrMode;	/* addressing mode (HSGADR or REDBOOK) */
	char far *fpBuffer;	/* pointer to transfer buffer */
	unsigned	uSize;		/* number of sectors to read */
	union
	{
		unsigned long	ulNumber;	/* sector number (HSGADR) */
		t_REDBOOK			tRedBook;	/* Red Book address */
	}	sSector;					/* adr of first sector to read */
	char			cDatMode;	/* data read mode (COOKED or RAWDATA) */
	char			cIlSize;	/* interleave size */
	char			cIlSkip;	/* interleave skip factor */
}	t_READL;

typedef struct s_TRACKINFO	/* data returned by 'audio track info' */
{
	t_REDBOOK			tStartAdr;	/* start-address of track (RedBook) */
	unsigned char	ucCtrl;			/* ctrl/adr bits */
}	t_TRACKINFO;

typedef struct s_DEVSTATUS	/* CDROM device status word */
{															/* if set: */
	unsigned	uDoorOpen:1;			/* door is open */
	unsigned	uUnlocked:1;			/* door is unlocked */
	unsigned	uRawData:1;				/* supports raw-data read */
	unsigned	uWrite:1;					/* supports write */
	unsigned	uAudioPlay:1;			/* supports audio play */
	unsigned	uInterleave:1;		/* supports interleaving */
	unsigned	uRsvd3:1;
	unsigned	uPrefetch:1;			/* supports prefetching requests */
	unsigned	uAudioChannel:1;	/* supports audio-channel manipulation */
	unsigned	uRedBookAdr:1;		/* supports red-book addressing */
	unsigned	uRsvd2:1;
	unsigned	uNoDisk:1;				/* no disk in drive */
	unsigned	uRWsub:1;					/* supports R-W sub-channels */
	unsigned	uRsvd1:3;
	unsigned	uRsvd0:16;
}	t_DEVSTATUS;

typedef struct s_CDDATA		/* CDROM-drive data as returned by MSCDEX */
{
	char				cUnit;						/* sub-unit of driver */
	t_CDDRVHDR	*fpDriverHeader;	/* pointer to driver's header */
}	t_CDDATA;

/* 
	functions; see file 'CDROMF.C'
*/
unsigned MSCDEX_DriverRequest( int iCDno, t_REQHDR *ptReqHdr );
unsigned MSCDEX_IoctlRequest( int iCDno, unsigned uCmd, char *pcBuffer );
int ReadCDSectors( int iCDno, char *pcBuffer, unsigned long ulSector, unsigned uCount );

/*
	lower functions; see file 'CDROMFA.ASM'
*/
int MSCDEX_NumberOfDrives( void );
void MSCDEX_GetCDDrives( char far *fpc );
void MSCDEX_GetCDDeviceList( t_CDDATA far *fptCDData );
unsigned MSCDEX_DriverSendRequest( int iCDno, t_REQHDR far *ptReqHdr );

#endif /* ndef _CDROM_H_ */

