{$B-,R-,S-,E+,N+}
{$ifopt F+} {$define farcalls} {$endif}

unit math;


interface

uses init;


function sqrt(X:float):float;    { exported because system.sqrt is defective }

function enter(X,Y,R:float):float;      { statistics x,y entry (or deletion) }

function calendar(month,year:integer):string;


function _random:float;

function _sin(X:float):float;
function _cos(X:float):float;
function _tan(X:float):float;

function _arcsin(X:float):float;
function _arccos(X:float):float;
function _arctan(X:float):float;
function _arctan2(X,Y:float):float;

function _sinh(X:float):float;
function _cosh(X:float):float;
function _tanh(X:float):float;

function _arcsinh(X:float):float;
function _arccosh(X:float):float;
function _arctanh(X:float):float;

function _roundup(X:float):float;
function _round(X:float):float;
function _sign(X:float):float;

function _power(X,Y:float):float;
function _modulo(X,Y:float):float;

function _factorial(X:float):float;
function _nCr(X,Y:float):float;
function _nPr(X,Y:float):float;
function _gcd(R1,R2:float):float;
function _lcm(R1,R2:float):float;

function _snormal(X:float):float;
function _poisson(u,y:float):float;
function _binomial(p,n,y:float):float;

function _stddev(mode:byte):float;
function _pearson:float;
function _valM:float;
function _valB:float;

function _pmt(P,I,N:float):float;
function _fv(P,I,N:float):float;
function _pv(P,I,N:float):float;
function _cterm(I,FV,PV:float):float;
function _term(P,I,FV:float):float;
function _rate(FV,PV,N:float):float;

function _hms(X:float):float;
function _hr(H,M,S:float):float;

procedure _lim(var R1,R2:float; R3:float; init:boolean);
procedure _sum(var R1:float; R2:float; init,sqrr,fini:boolean);



implementation



function calendar(month,year:integer):string;
type char2=array [1..2] of char;
     char3=array [1..3] of char;
const daymonth:array [false..true,1..12] of byte=
               ((31,28,31,30,31,30,31,31,30,31,30,31),
                (31,29,31,30,31,30,31,31,30,31,30,31));

var century,holder:integer;
          leapyear:boolean;
      B,C,daycount:byte;
          template:record
                     case byte of 0:(final:string);
                                  1:(count:byte;
                                     title:array [1..39] of char;
                                     lines:array [0..4] of
                                           record
                                             slots:array [0..6] of
                                                   record
                                                     blank:char3;
                                                     chars:char2
                                                   end;
                                             cr_lf:char2
                                           end)
                     end;

  function ascii(B:byte):word;
  inline(
  $58/               { pop  AX         ; get parameter from stack   }
  $D4/$0A/           { aam             ; div/mod 10 into AH/AL      }
  $0D/$30/$30/       { or   AX,3030h   ; convert into 2 ascii chars }
  $86/$E0/           { xchg AH,AL      ; put 10's digit first (AL)  }
  $3C/$30/           { cmp  AL,30h     ; check for leading zero     }
  $75/$02/           { je   $+4        ; skip if not ...            }
  $B0/$20);          { mov AL,20h      ; else convert into a space  }

begin
  leapyear:=((year mod 4)=0) and (((year mod 100)<>0) or ((year mod 400)=0));
  daycount:=daymonth[leapyear,month];

  { Do the Zeller's Congruence calculation as Zeller himself }
  { described it in "Acta Mathematica" #7, Stockhold, 1887.  }

  { We adjust the month such that March remains month #3, }
  { but that January and February are months #13 and #14, }
  { *but of the previous year* : }

  if month < 3 then begin inc(month,12); dec(year) end;

  century:=year div 100;
  year:=year mod 100;

  holder:=1;                                { find d-o-w of the first day }
  inc(holder,((month+1)*26) div 10);
  inc(holder,year);
  inc(holder,year div 4);
  inc(holder,century div 4);
  dec(holder,century*2);

  holder:=holder mod 7;
  if holder<0 then inc(holder,7);
  if holder=0 then holder:=7;        { 1=sunday, 2=monday, ... 7=saturday }


  fillchar(template,sizeof(template),#032);
  template.count:=sizeof(template.title)+sizeof(template.lines);
  template.title:=#013#010'  sun  mon  tue  wed  thu  fri  sat'#013#010;
  for B:=0 to 4 do template.lines[B].cr_lf:=#013#010;

  for B:=1 to daycount do            { B ranges over days }
  begin
    C:=(B+holder-2) mod 35;          { div/mod 7 to get slot location }
    word(template.lines[C div 7].slots[C mod 7].chars):=ascii(B)
  end;

  calendar:=template.final
end;


function enter(X,Y,R:float):float;  { adds (or deletes) X,Y to stats registers }
var Rx:regstype;
begin
  Rx:=register;
  Rx[4]:=register[4]+R;
  Rx[5]:=register[5]+R*X;
  Rx[6]:=register[6]+R*Y;
  Rx[7]:=register[7]+R*sqr(X);
  Rx[8]:=register[8]+R*sqr(Y);
  Rx[9]:=register[9]+R*X*Y;
  register:=Rx;
  enter:=register[4]
end;


{ ************************************************************************** }
function sqrt(X:float):float;              { the Turbo 5.5 sqrt function is  }
begin                                      { defective, sometimes causing a  }
  if X<0.0 then runerror(error_inval_op)   { program exit without generating }
           else sqrt:=system.sqrt(X)       { any runtime error if passed a   }
end;                                       { negative argument.              }
{ ************************************************************************** }


const positive=$01;
      negative=$02;
          zero=$04;


function float2int(R:float; mask:byte):longint;  { converts float to longint }
begin
  if ((R>0.0) and ((mask and positive)=0)) or
     ((R<0.0) and ((mask and negative)=0)) or
     ((R=0.0) and ((mask and zero    )=0)) or
     (R>maxlongint) or (R<-maxlongint-1.0) or
     (frac(R)<>0)                          then runerror(error_intrange);
  float2int:=trunc(R)
end;


procedure Xconvert(var X:float);       { current trig mode -> radians }
begin
  case trigmode of deg:X:=X*pi/180.0;
                   gra:X:=X*pi/200.0
  end  { of case }
end;


procedure Rconvert(var R:float);       { radians -> current trig mode }
begin
  case trigmode of deg:R:=R/pi*180.0;
                   gra:R:=R/pi*200.0
  end  { of case }
end;


{ ************************************************************************** }


function _random:float;
begin
  randseed:=frac((9821.0*randseed)+0.211327);
  _random:=randseed
end;


function _sin(X:float):float;
begin
  Xconvert(X);
  _sin:=sin(X)
end;


function _cos(X:float):float;
begin
  Xconvert(X);
  _cos:=cos(X)
end;


function _tan(X:float):float;
begin
  Xconvert(X);
  _tan:=sin(X)/cos(X)
end;


function _arcsin(X:float):float;
var R:float;
begin
  if abs(X)=1.0 then R:=X*pi/2.0
                else R:=arctan(X/sqrt(1.0-sqr(X)));
  Rconvert(R);
  _arcsin:=R
end;


function _arccos(X:float):float;
var R:float;
begin
  if X=+1.0 then R:=0.0 else
  if X=-1.0 then R:=pi
            else R:=(pi/2.0)-arctan(X/sqrt(1.0-sqr(X)));
  Rconvert(R);
  _arccos:=R
end;


function _arctan(X:float):float;
var R:float;
begin
  R:=arctan(X);
  Rconvert(R);
  _arctan:=R
end;


function _arctan2(X,Y:float):float;
var R:float;
begin
  if X=0.0 then
  begin
    R:=pi/2.0;
    if Y<0.0 then R:=-R else
    if Y=0.0 then runerror(error_inval_op)
  end else
  begin
    R:=arctan(Y/X);
    if X<0.0 then if Y>0.0 then R:=R+pi
                           else R:=R-pi
  end;
  Rconvert(R);
  _arctan2:=R
end;


function _sinh(X:float):float;
begin
  _sinh:=(exp(X)-exp(-X))/2.0
end;


function _cosh(X:float):float;
begin
  _cosh:=(exp(X)+exp(-X))/2.0
end;


function _tanh(X:float):float;
begin
  _tanh:=(exp(X)-exp(-X))/(exp(X)+exp(-X))
end;


function _arcsinh(X:float):float;
begin
  _arcsinh:=ln(X+sqrt(sqr(X)+1.0))
end;


function _arccosh(X:float):float;
begin
  _arccosh:=ln(X+sqrt(sqr(X)-1.0))
end;


function _arctanh(X:float):float;
begin
  _arctanh:=ln((1.0+X)/(1.0-X))/2.0
end;


function _roundup(X:float):float;
begin
  if frac(X)=0.0 then _roundup:=X else
  if X<0.0 then _roundup:=int(X-1.0)
           else _roundup:=int(X+1.0)
end;


function _round(X:float):float;
begin
  if X<0.0 then _round:=int(X-0.5)
           else _round:=int(X+0.5)
end;


function _sign(X:float):float;
begin
  if X<0.0 then _sign:=-1.0 else
  if X>0.0 then _sign:=+1.0 else _sign:=0.0
end;


function _power(X,Y:float):float;
var R:float;
    L:longint;
begin
  if ((X<0.0) and (frac(Y)<>0.0)) or
     ((X=0.0) and (Y<=0.0)) then runerror(error_inval_op);

  if (frac(Y)=0.0) and (abs(Y)<=maxlongint) then
  begin
    L:=trunc(Y);
    if L<0 then X:=1.0/X;
    L:=abs(L);
    if odd(L) then R:=X
              else R:=1.0;
    repeat
      L:=(L shr 1);
      if L<>0 then X:=sqr(X);
      if odd(L) then R:=R*X
    until L=0;
    _power:=R
  end
  else  { ****** }
  begin
    R:=exp(ln(abs(X))*Y);
    if (X<0.0) and (frac(abs(Y/2.0))>0.25) then _power:=-R
                                           else _power:=+R
  end
end;


function _modulo(X,Y:float):float;
var R:real;
begin
  R:=frac(X/Y)*Y;
  if (abs(X)=abs(Y)) or (X=0.0) then _modulo:=0.0 else
  if (X>0.0) xor (Y>0.0) then _modulo:=R+Y
                         else _modulo:=R
end;


function _factorial(X:float):float;
var I,N:longint;
      A:float;
begin
  A:=1.0;
  N:=float2int(X,positive or zero);
  for I:=2 to N do A:=A*I;
  _factorial:=A
end;


function _nCr(X,Y:float):float;
var I,N,R:longint;
        A:float;
begin
  A:=1.0;
  N:=float2int(X,positive or zero);
  R:=float2int(Y,positive or zero);
  if N<R then runerror(error_intrange);
  for I:=1 to N-R do A:=A*(I+R)/I;
  _nCr:=A
end;


function _nPr(X,Y:float):float;
var I,N,R:longint;
        A:float;
begin
  A:=1.0;
  N:=float2int(X,positive or zero);
  R:=float2int(Y,positive or zero);
  if N<R then runerror(error_intrange);
  for I:=N-R+1 to N do A:=A*I;
  _nPr:=A
end;


procedure _lim(var R1,R2:float; R3:float; init:boolean);
begin
  if init then begin            { R1 <- min, R2 <- max }
                 R1:=R3;
                 R2:=R3
               end
          else begin
                 if R3<R1 then R1:=R3;
                 if R3>R2 then R2:=R3
               end
end;


procedure _sum(var R1:float; R2:float; init,sqrr,fini:boolean);
begin
  if init then R1:=0.0;
  if sqrr then R1:=R1+sqr(R2)
          else R1:=R1+R2;
  if fini then R1:=sqrt(R1)
end;


function _gcd(R1,R2:float):float;
var L1,L2:longint;
begin
  break:=false;
  L1:=float2int(abs(R1),positive);
  L2:=float2int(abs(R2),positive);
  while L1<>L2 do
  begin
    if L1>L2 then dec(L1,L2)
             else dec(L2,L1);
    if break then runerror(error_breakkey)
  end;
  _gcd:=L1
end;


function _lcm(R1,R2:float):float;
var L1,L2,M1,M2:longint;
begin
  break:=false;
  L1:=float2int(abs(R1),positive);
  L2:=float2int(abs(R2),positive);
  M1:=L1;
  M2:=L2;
  while L1<>L2 do
  begin
    if L1<L2 then inc(L1,M1)
             else inc(L2,M2);
    if break then runerror(error_breakkey)
  end;
  _lcm:=L1
end;


function _pmt(P,I,N:float):float;
begin
  _pmt:=P*I/(1.0-exp(-N*ln(1.0+I)))
end;


function _fv(P,I,N:float):float;
begin
  _fv:=P*(exp(N*ln(1.0+I))-1.0)/I
end;


function _pv(P,I,N:float):float;
begin
  _pv:=P*(1.0-exp(-N*ln(1.0+I)))/I
end;


function _cterm(I,FV,PV:float):float;
begin
  _cterm:=ln(FV/PV)/ln(1.0+I)
end;


function _term(P,I,FV:float):float;
begin
  _term:=ln(1.0+(I*FV/P))/ln(1.0+I)
end;


function _rate(FV,PV,N:float):float;
begin
  _rate:=exp(ln(FV/PV)/N)-1.0
end;


function _snormal(X:float):float;
var A,R,X2:float;
       N,I:byte;
begin
  break:=false;
  X2:=sqr(X);
  if X>+5.0 then _snormal:=+0.5 else
  if X<-5.0 then _snormal:=-0.5 else
  begin
    A:=0.0;
    N:=0;
    repeat
      R:=X/((2.0*N)+1.0);
      for I:=1 to N do R:=R*X2/(2.0*I);
      if odd(N) then A:=A-R
                else A:=A+R;
      inc(N);
      if break then runerror(error_breakkey)
    until (abs(R)<1e-10) or (N>99);
    _snormal:=round(1e6*A/sqrt(2.0*pi))/1e6
  end
end;


function _poisson(u,y:float):float;
var I,J,K:longint;
      A,R:float;
begin
  break:=false;
  K:=float2int(y,positive or zero);
  if u<0.0 then runerror(error_n_format);
  A:=0.0;
  for J:=0 to K do
  begin
    R:=exp(-u);
    for I:=1 to J do R:=R*u/I;
    A:=A+R;
    if break then runerror(error_breakkey)
  end;
  _poisson:=A
end;


function _binomial(p,n,y:float):float;
var I,J,sample,yvalue:longint;
    R,S,l1,l2:float;
begin
  break:=false;
  sample:=float2int(n,positive or zero);
  yvalue:=float2int(y,positive or zero);
  if yvalue>sample then runerror(error_intrange);
  l1:=ln(p);
  l2:=ln(1.0-p);
  S:=0.0;
  for J:=0 to yvalue do
  begin
    R:=1.0;
    for I:=1 to sample-J do R:=R*(I+J)/I;
    S:=S+(R*exp((l1*J)+(l2*(sample-J))));
    if break then runerror(error_breakkey)
  end;
  _binomial:=S
end;


function _pearson:float;
begin
  with statregs do
  _pearson:=(Sxy-(Sx*Sy/n))/sqrt((Sxx-(sqr(Sx)/n))*(Syy-(sqr(Sy)/n)))
end;


function _stddev(mode:byte):float;
var S,SS,R:float;
begin
   if (mode and $01)=0 then begin S:=register[5]; SS:=register[7] end
                       else begin S:=register[6]; SS:=register[8] end;
   R:=SS-(sqr(S)/register[4]);
   if (mode and $02)=0 then R:=R/(register[4]-1.0)       { sample }
                       else R:=R/register[4];        { population }
   _stddev:=sqrt(R)
end;


function _valM:float;
begin
  with statregs do
  _valM:=(Sxy-(Sx*Sy/n))/(Sxx-(sqr(Sx)/n))
end;


function _valB:float;
begin
  with statregs do
  _valB:=(Sy-(Sx*_valM))/n
end;


function _hms(X:float):float;
var H,M,S:float;
begin
  H:=int(X);
  M:=int((X*60.0)-(H*60.0));
  S:=(X*3600.0)-(H*3600.0)-(M*60.0);
  _hms:=H+(M/100.0)+(S/10000.0)
end;


function _hr(H,M,S:float):float;
begin
  _hr:=(((S/60.0)+M)/60.0)+H
end;


begin
end.