/**
 ** RPNIO.H
 **
 ** Dimensions & colors for the calculator display window & help windows.
 ** For version 2, these two defines become global variables in "rpn.h":
 **	#define TOP       6
 **	#define LEFT      39
 **
 ** For v2.3, these defines become global variables in "rpn.h":
 **	#define D_BKGND   BLACK
 **	#define D_BORDER  LIGHTGRAY
 **	#define D_NUM     YELLOW
 **	#define D_FTN     CYAN
 **
 ** 90.05.23 v3.0
 **	Complete defines for the function-keys and some others;
 **	Help-window defines.  Display-window stuff moved out.
 **/
#ifndef RPNIO_H
#define RPNIO_H


#if (__TURBOC__ < 0x0200)
#define NEWLINE "\n"
#else
#define NEWLINE "\n\r"
#endif

/*
| Cursor keys, used to move the display around.
| These consist of the 2nd byte of the extended scan code, concatenated
| onto 0x1b (the 1st byte) to form a legal signed integer.
*/
#define MOVELEFT	0x1b4b
#define MOVERIGHT	0x1b4d
#define MOVEUP		0x1b48
#define MOVEDOWN	0x1b50
	/* a.k.a. */
#define LARR	0x1b4b
#define RARR	0x1b4d
#define UARR	0x1b48
#define DARR	0x1b50

/*
| f1..f10 keys
| These consist of the 2nd byte of the extended scan code, concatenated
| onto 0x1b (to form a legal signed integer).
*/
#define FTN_1	0x1b3b
#define FTN_2	0x1b3c
#define FTN_3	0x1b3d
#define FTN_4	0x1b3e
#define FTN_5	0x1b3f
#define FTN_6	0x1b40
#define FTN_7	0x1b41
#define FTN_8	0x1b42
#define FTN_9	0x1b43
#define FTN_10	0x1b44

#define S_FTN_1		0x1b54
#define S_FTN_2		0x1b55
#define S_FTN_3		0x1b56
#define S_FTN_4		0x1b57
#define S_FTN_5		0x1b58
#define S_FTN_6		0x1b59
#define S_FTN_7		0x1b5a
#define S_FTN_8		0x1b5b
#define S_FTN_9		0x1b5c
#define S_FTN_10	0x1b5d

#define C_FTN_1		0x1b5e
#define C_FTN_2		0x1b5f
#define C_FTN_3		0x1b60
#define C_FTN_4		0x1b61
#define C_FTN_5		0x1b62
#define C_FTN_6		0x1b63
#define C_FTN_7		0x1b64
#define C_FTN_8		0x1b65
#define C_FTN_9		0x1b66
#define C_FTN_10	0x1b67

#define A_FTN_1		0x1b68
#define A_FTN_2		0x1b69
#define A_FTN_3		0x1b6a
#define A_FTN_4		0x1b6b
#define A_FTN_5		0x1b6c
#define A_FTN_6		0x1b6d
#define A_FTN_7		0x1b6e
#define A_FTN_8		0x1b6f
#define A_FTN_9		0x1b70
#define A_FTN_10	0x1b71

/*
| Other special keys.  All the special keys are listed in the doco.
| (scancode.txt, maybe?)
*/
#define DEL	0x1b53
#define INS	0x1b52
#define PGUP	0x1b49
#define PGDN	0x1b51
#define END	0x1b4f
#define HOME	0x1b47

#define SCROLL_LOCK	0x10		/* mask for kbd_status byte */


/**********  Default frame colors  **************/

#define DBKGND BLACK
#define DBORD  LIGHTGRAY
#define DNUM   YELLOW
#define DFTN   CYAN
#define DOOPS  LIGHTRED


/**********  defines for Help windows  **********/

#define  H_BKGND   RED
#define  H_BORDER  BLACK
#define  H_TITLE   YELLOW
#define  H_LABEL   LIGHTCYAN
#define  H_TEXT    WHITE
#define  H_NUM     LIGHTGRAY

#define H_LEFT    1
#define H_TOP     1
#define H_WIDTH  40
#define H_DEPTH  24
#define H_RIGHT  (H_LEFT-1 + H_WIDTH)
#define H_BOTTOM  (H_TOP-1 + H_DEPTH)

#define HT_OFF   16   /** Relative location of the definitions for **/
#define HL_OFF   11   /** the last block of commands (lower right) **/

#define H2_LEFT  (H_RIGHT+1)
#define H2_RIGHT (H2_LEFT-1 + H_WIDTH)
#define H2_TOP    H_TOP
#define H2_BOTTOM (H2_TOP-1 + 5)

#endif  /* RPNIO_H */
