/**
 ** MAKEHELP
 **
 ** Make Help windows.
 **
 ** 90.01.01
 **/
#include <conio.h>
#include <string.h>
#include "rpn.h"
#include "rpnio.h"
#include "helps.h"

/* local abbreviations */
#define HN H_NUM
#define HL H_LABEL
#define HC H_TEXT
#define HT H_TITLE


/*
| Looks like 22 lines...
*/
char h_frame[ (H_RIGHT-H_LEFT+1) * (H_BOTTOM-H_TOP+1) + 1 ] =
/* ---------+---------+---------+-------- + */
 "Ŀ"
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "                                      "
 "\000";
/* ---------+---------+---------+-------- + */

/*
 * spare parts:    :
 * char h1_bar2[] = "";
 */

char horiz_bar[] =
 "Ĵ";
char bottom_bar[] =
 "";

char h1_bar1[] = "³";
#define BAR_H  14		/* position of inserted */
#define BAR_V   8		/*   h1_bar1 string     */
char h1_bar2[] = "";
#define BAR_H2  7
#define BAR_V2 10

char h1_label[] = " Help Screen 1 ";
char h2_label[] = " Help Screen 2 ";

help_text help1[] = {
/* ---------+---------+---------+-------- + */
  "+ - * / %  I",HC,
	      "nvert  ",HN,
		     "abs frac int !",HC,
				   "",HL,
				    "fact",HC,
/* ---------+---------+---------+-------- + */
  "exp ln lg log  ^",HC,
		  "",HL,
		   "pow  p10",HC,
			   "",HL,
			    "pow10  gamma",HC,
/* ---------+---------+---------+-------- + */
  "C",HC,
   "learX ",HN,
	 "L",HC,
	  "astX  ",HN,
		"pi  sqr sqrt  ",HC,
			      "X\x1DY: ",HL,
				   "X",HC,
				    "chng",HN,
/* ---------+---------+---------+-------- + */
  "clrstk clrreg clrblk",HC,
		      "Y..X  ",HN,
			    "CHS:",HL,
				"'",HC,
				 "",HL,
				  "N",HC,
				   "egate",HN,
/* ---------+---------+---------+-------- + */
  0,0,	/* terminal entry */


  "sin asin  rad   sinh isinh  csch icsch",HC,
  "cos acos  deg   cosh icosh  sech isech",HC,
  "tan atan        tanh itanh  coth icoth",HC,
  " atan2",HC,
	"(Y/X) ",HN,
	      "  hms  hrs   polar  rect  ",HC,
  "<CTRL>R",HC,
	 " / ",HL,
	    "<CTRL>D ",HC,
		    "Radians/Degrees mode",HL,
/* ---------+---------+---------+-------- + */
  0,0,	/* terminal entry */


/* ---------+---------+---------+-------- + */
  "",HC, "",HL, "ru",HC, " / ",HL, "",HC, "",HL, "rd  ",HC,
	"Stack - roll Up / Down   ",HL,
  "    <CR>     ",HC, "Do-Function or Enter     ",HL,
  "   <SPACE>   ",HC, "Enter (push stack)       ",HL,
  "    <ESC>    ",HC, "erase Ftn or close Help  ",HL,
  "    init     ",HC, "Re-initialize RPN calc.  ",HL,
  "<SCROLL-LOCK>",HC, "Reposition display window",HL,
  "    <F1>     ",HC, "cycle thru HELPscreens   ",HL,
  "    <F2>     ",HC, "toggle save-file on/off  ",HL,
  " <CTRL><F10> ",HC, "Quit, but leave windows  ",HL,
  " <SHFT><F10> ",HC, "escape to sub-shell      ",HL,
  "    <F10>    ",HC, "  QUIT                   ",HL,
/* ---------+---       ------+---------+-------- + */
  0,0,	/* terminal entry */

  0,0	/* Final entry */
};   /**  help1  **/


help_text help2[] = {
  "Memory,Stats; Prts: ",HL,
		      "#",HT,
		       "=0..99i   ",HL,
				  "prtstk",HC,
/* ---------+---------+---------+-------- + */
  "sto"  ,HC,
     ""  ,HL,
      "S "  ,HC,
	"{"  ,HL,
	 "+"  ,HC,
	  ""  ,HL,
	   "-"  ,HC,
	    ""  ,HL,
	     "*"  ,HC,
	      ""  ,HL,
	       "/"  ,HC,
		"} "  ,HL,
		  "#"  ,HT,
		   "     sum+"  ,HC,
			    ""  ,HL,
			     "]    prtreg",HC,
/* ---------+---------+---------+-------- + */
  "rcl",HC,
     "",HL,
      "R ",HC,
	"{"  ,HL,
	 "#",HT,
          "",HL,
	   "s",HC,
	    "um regs.",HN,
		    "}   "  ,HL,
		        "sum-",HC,
			    "",HL,
			     "[    prtsum",HC,
/* ---------+---------+---------+-------- + */
  "mean      linreg    lincoeffs   prtlin",HC,
  "geomean   linstats  interpx     clrsum",HC,
  "harmean  sd",HC,
	     ""  ,HL,
	      "stddev  interpy     clrlin",HC,
/* ---------+---------+---------+-------- + */
  0,0,	/* terminal entry */


  "rad    kg   liters  lymeters  meters  ",HC,
  "deg    lb   gal     ly        feet    ",HC,
  "polar  mps  igal    acres     fahr    ",HC,
  "rect   mph  cuinch  hectares  celsius ",HC,
  "km     hrs  joules  furlongs      ",HC,
				    "Unit",HL,
  "miles  hms  cal     yards  ",HC,
			     "Conversions",HL,
/* ---------+---------+---------+-------- + */
  0,0,	/* terminal entry */


  "Const's:  ",HL,
	    "pi c fc planck avogadro epsi",HC,
/* ---------+---------+---------+-------- + */
  0,0,	/* terminal entry */


  "default Hex Digits: ",HL,
		      "<ALT>-A ",HC,
			      ".. ",HL,
				 "<ALT>-F",HC,
/* ---------+---------+---------+-------- + */
  "Exponent, Precision, Base: ",HL,
  "E",HC,  "#  ",HT, "P",HC, "#  ",HT, "B",HC, "# ",HT,
/* ---------+---------+---------+-------- + */
  0,0,	/* terminal entry */

  "    <F3>     ",HC, "toggle fixed/sci notation",HL,
  "    <F1>     ",HC, "cycle thru HELPscreens   ",HL,
  "    <F10>    ",HC, "  QUIT                   ",HL,
/* ---------+---------+---------+-------- + */
  0,0,	/* terminal entry */

  0,0	/* Final entry */
};   /**  help2  **/


/*//////////////////////////////////////////////////////////////////////////*/

void make_help(const char *title, help_text *text, const char *signature)
{
    help_text *hp;
    int pos;
    struct text_info r;

    textbackground(H_BKGND);
    window(H_LEFT, H_TOP, H_RIGHT, H_BOTTOM+1);	/* left-side help window */
    textcolor(H_BORDER);
    cputs(h_frame);
    pos = (H_WIDTH - strlen(title))/2;
    window(H_LEFT + pos, H_TOP, H_RIGHT, H_TOP);
    textcolor(H_TITLE);
    cputs(title);

    window(H_LEFT+1, H_TOP+1, H_RIGHT-1, H_BOTTOM+1);
    hp = text;
    do {
	for ( ; hp->text != 0; ++hp) {
	    textcolor(hp->color);
	    cputs(hp->text);
	}
	gettextinfo(&r);
	window(H_LEFT, r.cury+1, H_RIGHT, H_BOTTOM+1);
	textcolor(H_BORDER);
	cputs(horiz_bar);
	window(H_LEFT+1, H_TOP+1, H_RIGHT-1, H_BOTTOM+1);
	gotoxy(r.curx, r.cury+1);
	keypause();
    } while ( (++hp)->text != 0 );

    window(H_LEFT, r.cury+1, H_RIGHT, H_BOTTOM+1);
    textcolor(H_BORDER);
    cputs(bottom_bar);

    if (signature) {
	window(H_LEFT+1, H_BOTTOM, H_RIGHT, H_BOTTOM+1);
	textcolor(H_TITLE);
	cputs(signature);
    }
}
