(*--------------------------------------------------------------------------*)
(*                  ReadLine -- Read PibCalc command line                   *)
(*--------------------------------------------------------------------------*)

PROCEDURE ReadLine;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*     Procedure: ReadLine                                                  *)
(*                                                                          *)
(*     Purpose:   Reads PibCalc command line                                *)
(*                                                                          *)
(*     Calling sequence:                                                    *)
(*                                                                          *)
(*        ReadLine;                                                         *)
(*                                                                          *)
(*     Calls:                                                               *)
(*                                                                          *)
(*        TextColor                                                         *)
(*        UpCase                                                            *)
(*        COPY                                                              *)
(*                                                                          *)
(*     Called by:                                                           *)
(*                                                                          *)
(*        PibCalc (Main program)                                            *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

LABEL
   1, 99;

VAR
   c: CHAR;

BEGIN (* Readline *)

                                   (* Check if we have edited line to *)
                                   (* be used as command line. If so, *)
                                   (* skip command line read.         *)

   IF UseEdit THEN
      BEGIN
         Iline   := Oline;
         UseEdit := FALSE;
         Ipos    := 1;
         GOTO 99;
      END;

                                   (* Save previous command line      *)
   Oline := Iline;
                                   (* Prompt for input                *)
1: TEXTCOLOR( Prompt_Color );
   WRITE('? ');
   TEXTCOLOR( ForeGround_Color );

                                   (* Initialize input Iline to null  *)
                                   (* Ipos used globally as current   *)
                                   (* position in in Iline            *)
   Ipos  := 0;
   Iline := '';
                                   (* Get first character in line     *)
   READ( c );
                                   (* Loop over input                 *)

   WHILE ( Ipos < ( Maxstrlen - 1 ) ) AND ( NOT EOLN ) DO
      BEGIN
                                   (* Ctrl-x is line-delete char.     *)
         IF c = Ctrlx THEN
            BEGIN
               WRITE(' *** DELETED');
               WRITELN;
               GOTO 1;
            END                    (* Back up in line if backspace    *)
         ELSE IF ( c = bs ) OR ( c = del ) THEN
            IF Ipos > 0 THEN
               BEGIN
                  Ipos  := Ipos - 1;
                  WRITE(bs,' ',bs);
                  IF Ipos > 0 THEN
                     Iline := COPY( Iline, 1, Ipos )
                  ELSE
                     Iline := '';
               END
            ELSE
               BEGIN
                  Ipos  := 0;
                  Iline := '';
               END
         ELSE                      (* Ordinary character -- convert to *)
                                   (* upper case and append to Iline.  *)
           BEGIN
              Ipos  := Ipos + 1;
              IF c IN ['a'..'z'] THEN c := UPCASE( c );
              Iline := Iline + c;
           END;
                                   (* Get next character               *)
         READ( c );

     END;
                                   (* Add end-of-string marker COL and *)
                                   (* reset Ipos to 1 = start of Iline *)
   Iline := Iline + COL;
   Ipos  := 1;

99:
END  (* Readline *);

(*--------------------------------------------------------------------------*)
(*                 CheckEol -- Check for end-of-command-line                *)
(*--------------------------------------------------------------------------*)

PROCEDURE CheckEol;

BEGIN  (* CheckEol *)

   NextTok;

   IF Token <> eolsy THEN SynErr;

END    (* CheckEol *);
