(*--------------------------------------------------------------------------*)
(*                      Error --- Report execution error                    *)
(*--------------------------------------------------------------------------*)

PROCEDURE Error( E_Mess: AnyStr );

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*     Procedure:  Error                                                    *)
(*                                                                          *)
(*     Purpose:    Reports execution error                                  *)
(*                                                                          *)
(*     Calling Sequence:                                                    *)
(*                                                                          *)
(*        Error( E_Mess : AnyStr );                                         *)
(*                                                                          *)
(*           E_Mess --- Text of error message to be printed                 *)
(*                                                                          *)
(*     Calls:   TextColor                                                   *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

VAR
   i: INTEGER;

BEGIN (* Error *)

   TEXTCOLOR( Error_Message_Color );

   WRITELN;
   WRITELN( E_Mess );

   ErrorFlag := TRUE;

   TEXTCOLOR( ForeGround_Color );

END   (* Error *);

(*--------------------------------------------------------------------------*)
(*                      SynErr --- Report syntax error                      *)
(*--------------------------------------------------------------------------*)

PROCEDURE SynErr;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*     Procedure:  SynErr                                                   *)
(*                                                                          *)
(*     Purpose:    Reports syntax error                                     *)
(*                                                                          *)
(*     Calling Sequence:                                                    *)
(*                                                                          *)
(*        SynErr;                                                           *)
(*                                                                          *)
(*     Calls:   TextColor                                                   *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

BEGIN (* SynErr *)

   IF ( NOT ErrorFlag ) THEN
      BEGIN

         TEXTCOLOR( Error_Message_Color );

         WRITELN;
         WRITELN('Syntax Error');

         TEXTCOLOR( ForeGround_Color );

         ErrorFlag := TRUE;

      END;

END   (* SynErr *);

(*--------------------------------------------------------------------------*)
(*                Undef --- Reports variable is undefined                   *)
(*--------------------------------------------------------------------------*)

PROCEDURE Undef( v: Varnamty );

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*     Procedure:  Undef                                                    *)
(*                                                                          *)
(*     Purpose:    Reports variable is undefined                            *)
(*                                                                          *)
(*     Calling Sequence:                                                    *)
(*                                                                          *)
(*        Undef( v: Varnamty );                                             *)
(*                                                                          *)
(*     Calls:   TextColor                                                   *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

BEGIN  (* Undef *)

   TEXTCOLOR( Error_Message_Color );

   WRITELN(v,' is undefined');

   TEXTCOLOR( ForeGround_Color );

   ErrorFlag := TRUE;

END    (* Undef *);
