/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
invB(int n)
{
fraction det;

double pbA    [MXR][MXC*TWOCOL];matrix mA     = {MXR,MXC*TWOCOL,&pbA    [0][0]};
double pbB    [MXR][MXC*TWOCOL];matrix mB     = {MXR,MXC*TWOCOL,&pbB    [0][0]};
double pbP    [MXR][MXC*TWOCOL];matrix mP     = {MXR,MXC*TWOCOL,&pbP    [0][0]};
double pbinvP [MXR][MXC*TWOCOL];matrix minvP  = {MXR,MXC*TWOCOL,&pbinvP [0][0]};
double pbAP   [MXR][MXC*TWOCOL];matrix mAP    = {MXR,MXC*TWOCOL,&pbAP   [0][0]};
double pinvPAP[MXR][MXC*TWOCOL];matrix minvPAP= {MXR,MXC*TWOCOL,&pinvPAP[0][0]};
double pBinvP [MXR][MXC*TWOCOL];matrix mBinvP = {MXR,MXC*TWOCOL,&pBinvP [0][0]};
double pPBinvP[MXR][MXC*TWOCOL];matrix mPBinvP= {MXR,MXC*TWOCOL,&pPBinvP[0][0]};

                     mA.rows=n;                   mA.cols=n*TWOCOL;
                     mB.rows=n;                   mB.cols=n*TWOCOL;
                     mP.rows=n;                   mP.cols=n*TWOCOL;
                    mAP.rows=n;                  mAP.cols=n*TWOCOL;
                  minvP.rows=n;                minvP.cols=n*TWOCOL;
                 mBinvP.rows=n;               mBinvP.cols=n*TWOCOL;
                minvPAP.rows=n;              minvPAP.cols=n*TWOCOL;
                mPBinvP.rows=n;              mPBinvP.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  do
  {
               rndmI(&mP,5);
          det = detF(&mP);
  }while(!det.numer);

  rndmI(&mA,5);

  inverseF(&mP,&minvP);
    multmF(&mA,&mP,&mAP);
    multmF(&minvP,&mAP,&mB);

  clrscrn();
  printf(" If A and B are square matrices, \n");
  printf(" we say that B is similar to A\n");
  printf(" if there is an invertible matrix P such that :\n\n");
  printf("            B = invPAP\n\n");
  printf("                                                               A :");
  printmI(&mA);
  printf("                                                               B :");
  printmF3(&mB);
  printf("                                                         If P is :");
  printmI(&mP);
  printf("                                                         invP is :");
  printmF3(&minvP);
  getchar();

  clrscrn();
  printf("                                                               B :");
  printmF4(&mB);
  printf("                                                          invPAP :");
  multmF(&minvP,&mAP,&minvPAP);
  printmF4(&minvPAP);
  printf("                               B = invPAP also B is similar to A :\n\n");
  getchar();

  clrscrn();
  printf(" If B is similar to A, :\n");
  printf(" necessarily A is similar to B.\n\n");
  printf(" Also there is an invertible matrix P such that :\n\n");
  printf("            A = PBinvP\n\n");
  printf("                                                               B :");
  printmF3(&mB);
  printf("                                                            P is :");
  printmF3(&mP);
  printf("                                                         invP is :");
  printmF3(&minvP);
  getchar();

  clrscrn();
  multmF(&mB,&minvP,&mBinvP);
  multmF(&mP,&mBinvP,&mPBinvP);
  printf("                                                               A :");
  printmI(&mA);
  printf("                                                          PBinvP :");
  printmI(&mPBinvP);
  printf("                               A = PBinvP also A is similar to B :\n\n");

}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n\n\n                                              ");
  printf("\n              if B is similar to A,             \n");
  printf("\n                 A is similar to B.             \n");
  printf("\n                 *****************               \n");
  printf("\n\n\n\n                                            ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 3){n=3;}}
else
 {  n = rndpI(3);}
if( n < 2){n=2;}


  invB(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}



