/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n
)
{
fraction InnerProduct_uv;
fraction InnerProduct_k_uv;
fraction InnerProduct_u_kv;
fraction k;

double pbA [MXR][MXC*TWOCOL];matrix mA ={MXR,MXC*TWOCOL,&pbA [0][0]};
double pbu [MXR][MXC*TWOCOL];matrix mu ={MXR,MXC*TWOCOL,&pbu [0][0]};
double pbv [MXR][MXC*TWOCOL];matrix mv ={MXR,MXC*TWOCOL,&pbv [0][0]};
double pbkv[MXR][MXC*TWOCOL];matrix mkv={MXR,MXC*TWOCOL,&pbkv[0][0]};

    mA.rows = n;            mA.cols = n*TWOCOL;
    mu.rows = n;            mu.cols =   TWOCOL;
    mv.rows = n;            mv.cols =   TWOCOL;
   mkv.rows = n;           mkv.cols =   TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
     mdiagpF(&mA,5,2);
       rndmF(&mu,5,2);
       rndmF(&mv,5,2);
  k =  rndF (    5,2);

  clrscrn();
  printf("  Copy the weights w1,..,wn on the identity matrix : A \n");
  printmF(&mA);
  printf("\n                               (n x 1) : u ");
  printmF(&mu);
  printf("\n                               (n x 1) : v ");
  printmF(&mv);
  printf("\n    k = %.0lf/%-.0lf \n",k.numer,k.denom);
  getchar();

  clrscrn();
  printf("\n                               (n x 1) : v \n");
  printmF(&mv);
  printf("\n    k = %.0lf/%-.0lf \n",k.numer,k.denom);
  smultmF(k,&mv,&mkv);
  printf("                               kV\n");
  printmF3(&mkv);

  InnerProduct_u_kv = innerprod_W(&mA,&mu,&mkv);
  printf("\n <U,kV> =  %.0lf/%-.0lf \n\n",
            InnerProduct_u_kv.numer,
            InnerProduct_u_kv.denom);

  InnerProduct_uv = innerprod_W(&mA,&mu,&mv);
  printf("\n k<U,V> = (%.0lf/%-.0lf) (%.0lf/%-.0lf)\n\n",
            k.numer,
            k.denom,
            InnerProduct_uv.numer,
            InnerProduct_uv.denom);
  getchar();

  clrscrn();
  printf("\n  Weighed Euclidean Inner Product on R**n :");
  printf("\n               <U,kV>  =  k<U,V>     \n\n\n");
  printf("   <U,kV> =  %.0lf/%-.0lf\n\n",
            InnerProduct_u_kv.numer,
            InnerProduct_u_kv.denom);

  InnerProduct_k_uv = multF(k,InnerProduct_uv);
  printf("   k<U,V> =  %.0lf/%-.0lf\n\n",
            InnerProduct_k_uv.numer,
            InnerProduct_k_uv.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n     Weighed Euclidean Inner Product on R**n :  \n");
  printf("\n\n\n                                              ");
  printf("\n               <U,kV>  =  k<U,V>                  ");
  printf("\n               *****************                  ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {
  n = atoi(argv[1]); if( n > 5){n=5;}
  }
else
 {
  n=rndpI(5);
 }
   if(n<2){n=2;}


  AB(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

