/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n
)
{
fraction InnerProduct_uu;

double pbA[MXR][MXC*TWOCOL];matrix mA={MXR,MXC*TWOCOL,&pbA[0][0]};
double pbu[MXR][MXC*TWOCOL];matrix mu={MXR,MXC*TWOCOL,&pbu[0][0]};

   mA.rows = n;           mA.cols = n*TWOCOL;
   mu.rows = n;           mu.cols =   TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
mdiagpF(&mA,5,2);
  rndmF(&mu,5,2);

  clrscrn();
  printf("  Copy the weights w1,..,wn on the identity matrix : A \n");
  printmF(&mA);
  printf("\n                               (n x 1) : u \n");
  printmF(&mu);
  getchar();

  clrscrn();
  InnerProduct_uu = innerprod_W(&mA,&mu,&mu);
  printf("\n  Weighed Euclidean Inner Product on R**n :");
  printf("\n             (Positivity axiom)          \n");
  printf("\n\n    <U,U>  >=  0              \n\n");
  printf("\n\n    <U,U>   =  %6.0lf/%-6.0lf \n\n\n",
            InnerProduct_uu.numer,
            InnerProduct_uu.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n     Weighed Euclidean Inner Product on R**n :  \n");
  printf("\n             (Positivity axiom)                 \n");
  printf("\n\n\n                                              ");
  printf("\n                <U,U>  >=  0                      ");
  printf("\n                ************                      ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {
  n = atoi(argv[1]); if( n > 5){n=5;}
  }
else
 {
  n=rndpI(5);
 }
   if(n<2){n=2;}


  AB(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

