/* xkmtriag.h                   freeware                   xhunga@tiscali.fr  */

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void mlowertriangF(
pmatrix m,
int maxnumer,
int maxdenom)
{
int i;
int j;
int row;

  if (m->rows * TWOCOL != m->cols)
    {
     printf("\n mid() error - matrix must be square");
     printf("\n Press return to continue");
     getchar();
     exit(1);
    }
  for (   i = 0 ; i < m->rows ; i++)
    {
    for ( j = 0 ; j < m->cols ; j++,j++)
       {
       *(m->pblock+i *m->cols+j ) = 0;
       *(m->pblock+i *m->cols+j+1) = 1;

       if( (i*TWOCOL) >= j)
         {
          *(m->pblock+i *m->cols+j  ) = rndI (maxnumer);
          *(m->pblock+i *m->cols+j+1) = rndpI(maxdenom);
         }
       }
    }

    for ( row = 0; row < m->rows ; row++)
     {
      frowminiF(m,row);                                 /* a) fraction mini   */
     }
}

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void mlowertriangI(
pmatrix m,
int maxnumer)
{
int i;
int j;

  if (m->rows * TWOCOL != m->cols)
    {
     printf("\n mid() error - matrix must be square");
     printf("\n Press return to continue");
     getchar();
     exit(1);
    }
  for (   i = 0 ; i < m->rows ; i++)
    {
    for ( j = 0 ; j < m->cols ; j++,j++)
       {
       *(m->pblock+i *m->cols+j  ) = 0;
       *(m->pblock+i *m->cols+j+1) = 1;

       if( (i*TWOCOL) >= j)
         {
          *(m->pblock+i *m->cols+j) = rndI(maxnumer);
         }
       }
    }
}



/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void muppertriangF(
pmatrix m,
int maxnumer,
int maxdenom)
{
int i;
int j;
int row;

  if (m->rows * TWOCOL != m->cols)
    {
     printf("\n mid() error - matrix must be square");
     printf("\n Press return to continue");
     getchar();
     exit(1);
    }
  for (   i = 0 ; i < m->rows ; i++)
    {
    for ( j = 0 ; j < m->cols ; j++,j++)
       {
       *(m->pblock+i *m->cols+j  ) = 0;
       *(m->pblock+i *m->cols+j+1) = 1;

       if( (i*TWOCOL) <= j)
         {
          *(m->pblock+i *m->cols+j  ) = rndI (maxnumer);
          *(m->pblock+i *m->cols+j+1) = rndpI(maxdenom);
         }
       }
    }

    for ( row = 0; row < m->rows ; row++)
     {
      frowminiF(m,row);                                 /* a) fraction mini   */
     }
}


/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void muppertriangI(
pmatrix m,
int maxnumer)
{
int i;
int j;

  if (m->rows * TWOCOL != m->cols)
    {
     printf("\n mid() error - matrix must be square");
     printf("\n Press return to continue");
     getchar();
     exit(1);
    }
  for (   i = 0 ; i < m->rows ; i++)
    {
    for ( j = 0 ; j < m->cols ; j++,j++)
       {
       *(m->pblock+i *m->cols+j  ) = 0;
       *(m->pblock+i *m->cols+j+1) = 1;

       if( (i*TWOCOL) <= j)
         {
          *(m->pblock+i *m->cols+j) = rndI(maxnumer);
         }
       }
    }
}

