/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
gjA(int n)
{
fraction deter;
double pbvn   [MXR][MXC*TWOCOL];matrix mvn    ={MXR,MXC*TWOCOL,&pbvn   [0][0]};
double pbw    [MXR][MXC*TWOCOL];matrix mw     ={MXR,MXC*TWOCOL,&pbw    [0][0]};
double pbwT   [MXR][MXC*TWOCOL];matrix mwT    ={MXR,MXC*TWOCOL,&pbwT   [0][0]};
double pbw_s  [MXR][MXC*TWOCOL];matrix mw_s   ={MXR,MXC*TWOCOL,&pbw_s  [0][0]};
double pbvn_w [MXR][MXC*TWOCOL];matrix mvn_w  ={MXR,MXC*TWOCOL,&pbvn_w [0][0]};

                   mvn.rows=n;        mvn.cols= n   *TWOCOL;
                    mw.rows=n;         mw.cols=      TWOCOL;
                   mwT.rows=n;        mwT.cols=      TWOCOL;
                  mw_s.rows=n;       mw_s.cols=      TWOCOL;
                 mvn_w.rows=n;      mvn_w.cols=(n+1)*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
   rndmI(&mvn,6);
   rndmI(&mw, 6);

  deter = detF(&mvn);

  if(deter.numer)
  {
     copymF(&mvn, &mvn_w);
   copycolF(&mw,0,&mvn_w,((mvn_w.cols/2)-1));

   clrscrn();
   printf("  Let S = {v1, v2, ... } be a basis of R**n.\n\n");
   printmvI(&mvn,"  v");
   printf("\n  Find the coordinate vector of w,\n\n");
   printmvI(&mw,"  w");
   printf("\n  with respect to S.\n\n");
   printf("\n  We must find scalars, a, b, ... such that : \n\n");
   printavn_w(&mvn_w);
   getchar();

   clrscrn();
   printmvI(&mvn,"  v");
   printf("\n\n");
   printmvI(&mw,"  w");
   printf("\n\n   or, in terms of components :\n\n");
   printavn_wI(&mvn_w);
   getchar();

   clrscrn();
   printavn_wI(&mvn_w);
   printf("   If we equate components, we obtain the following augmented matrix :\n\n");
   printmI(&mvn_w);
   getchar();

   clrscrn();
   printf("  This reduces to :\n");
   gaussjordanF(&mvn_w);
   printmIF(    &mvn_w);
   printf("\n  The solution gives the values of a, b, ... Therefore,    \n\n");
   copycolF(&mvn_w,(((mvn_w.cols)/2)-1),&mw_s,0);
   printmvF(                            &mw_s,"  (w)s");
   getchar();

   clrscrn();
   printmvI(&mvn, "    v");
   printf("\n\n");
   printmvI(&mw,  "    w");
   printf("\n\n");
   printmvF(&mw_s," (w)s");
   printf("\n\n");
   printw_s_vnI(&mw_s,&mvn);
   printf("\n");
   addw_svnF(&mvn,&mw_s,&mwT);
   printmvI(            &mwT,"\n  ");
  }
  else{
   clrscrn();
   printf("   deter = %.0f",deter.numer);
  }
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n  Let S = {v1, v2, ... } be a basis of R**n.   \n\n");
  printf(" Find the coordinate vector of w with respect to S.\n");
  printf(" **************************************************\n");
  printf("\n The size of mv : 1x3 ... 1x4.                  \n");
  printf("\n           ex : \"ws_VI.exe\"                   \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"ws_VI.exe 2\" -> mvn_w 1x2         ");
  printf("\n                \"ws_VI.exe 3\" -> mvn_w 1x3         ");
  printf("\n                \"ws_VI.exe 4\" -> mvn_w 1x4         ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n = 2;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {
  ++n;
  if(n>4){n=2;}
 }
if( n < 2){n=2;}


  gjA(n);


printf("\n Press 'X' Return to stop :\n");
} while(toupper(getchar())!='X');

  return 0;
}

