/* xcpivot.h                   freeware                   xhunga@tiscali.fr  */

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
int pivotntzeroF(
pmatrix mA,
int row1,
int row2)
{
   int sign = 1;
double pivot;
double t;

  pivot = *(mA->pblock+row1 *mA->cols+row2*TWOCOL);
  if(!pivot)
  {
   row2 = row1+1;
   do
   {
    t = *(mA->pblock+row2 *mA->cols+row1*TWOCOL);
    if(t)
    {
     swaprowF(mA,row1,row2);
     row2 = mA->rows;
     sign = -1;
    }
    row2++;
   }
   while(row2 < mA->rows);
  }
return(sign);
}

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void pivotminiF(
pmatrix mA)
{
   int row;
fraction f;

  for (row = 0 ; row < mA->rows ; row++)
   {
   f.numer =  (*(mA->pblock+row *mA->cols+row*TWOCOL  ));
   f.denom =  (*(mA->pblock+row *mA->cols+row*TWOCOL+1));

    if((f.numer))
      {
         f = invF(f);
         mulrowF(mA,row,f);
       frowminiF(mA,row);
      }
   }
}

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
int pivotworkF(
pmatrix mA,
int     row1,
int     row2)
{
int      j;
double   t;
fraction f;
fraction fr2;
fraction pivot;
int      coefnulldoNothing = 1;

   fr2.numer = -(*(mA->pblock+row2 *mA->cols+row1*TWOCOL ));
   fr2.denom =   *(mA->pblock+row2 *mA->cols+row1*TWOCOL+1);

 pivot.numer =  (*(mA->pblock+row1 *mA->cols+row1*TWOCOL ));
 pivot.denom =   *(mA->pblock+row1 *mA->cols+row1*TWOCOL+1);

 if(pivot.numer)
 {
 for ( j = 0 ; j < mA->cols ; j++,j++ )
    {
/* ---------------------------------------------------------------- numerator */
                                                          f.numer = \
                       (
                   fr2.numer**(mA->pblock+row1 *mA->cols+j  )\
                              *\
                 pivot.denom**(mA->pblock+row2 *mA->cols+j+1)\
                        )
                     +\
                        (
                 pivot.numer**(mA->pblock+row2 *mA->cols+j   )\
                            *\
                  fr2.denom **(mA->pblock+row1 *mA->cols+j+1 )
                         );
/* -------------------------------------------------------------- denominator */
                                                       f.denom = \
           fr2.denom**(mA->pblock+row1 *mA->cols+j+1) *\
         pivot.denom**(mA->pblock+row2 *mA->cols+j+1);

          if(!f.numer){ f.denom = 1;}

          f = miniF(f);

    *(mA->pblock+row2 *mA->cols+j  ) = f.numer;
    *(mA->pblock+row2 *mA->cols+j+1) = f.denom;
    }
  }
  else{coefnulldoNothing = 0;}

  return(coefnulldoNothing);
}

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
int xpivotworkF(
pmatrix mA,
int     row1,
int     row2,
int     col)
{
int      j;
double   t;
fraction f;
fraction fr2;
fraction pivot;
int      coefnulldoNothing = 1;

   fr2.numer = -(*(mA->pblock+row2 *mA->cols+col*TWOCOL ));
   fr2.denom =   *(mA->pblock+row2 *mA->cols+col*TWOCOL+1);

 pivot.numer =  (*(mA->pblock+row1 *mA->cols+col*TWOCOL ));
 pivot.denom =   *(mA->pblock+row1 *mA->cols+col*TWOCOL+1);

 if(pivot.numer)
 {
 for ( j = 0 ; j < mA->cols ; j++,j++ )
    {
/* ---------------------------------------------------------------- numerator */
                                                          f.numer = \
                       (
                   fr2.numer**(mA->pblock+row1 *mA->cols+j  )\
                              *\
                 pivot.denom**(mA->pblock+row2 *mA->cols+j+1)\
                        )
                     +\
                        (
                 pivot.numer**(mA->pblock+row2 *mA->cols+j   )\
                            *\
                  fr2.denom **(mA->pblock+row1 *mA->cols+j+1 )
                         );
/* -------------------------------------------------------------- denominator */
                                                       f.denom = \
           fr2.denom**(mA->pblock+row1 *mA->cols+j+1) *\
         pivot.denom**(mA->pblock+row2 *mA->cols+j+1);

          if(!f.numer){ f.denom = 1;}

          f = miniF(f);

    *(mA->pblock+row2 *mA->cols+j  ) = f.numer;
    *(mA->pblock+row2 *mA->cols+j+1) = f.denom;
    }
  }
  else{coefnulldoNothing = 0;}

  return(coefnulldoNothing);
}


