/*****************************************************************************
   MODULE: rcputt.c
  PURPOSE: recio column delimited time output functions
COPYRIGHT: (C) 1994-1996, William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.15
  RELEASE: October 26, 1996
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "recio.h"

extern int _risready(REC *rp, int mode);
extern int _rputc(REC *rp, int ch);

#define rflags(rp)       ((rp)->r_flags)
#define rfp(rp)          ((rp)->r_fp)
#define rcol(rp)         ((rp)->r_colno)
#define rfldch(rp)       ((rp)->r_fldch)
#define rtmfmt(rp)       ((rp)->r_tmfmt)

/****************************************************************************/
void                         /* returns nothing                             */
    rcputtm(                 /* put time to record stream                   */
        REC *rp,             /* record pointer                              */
        size_t begcol,       /* field inclusive beginning column            */
        size_t endcol,       /* field inclusive ending column               */
        struct tm t)         /* broken-down time                            */
/****************************************************************************/
{
    size_t maxsize;          /* max size of str buffer */
    size_t len;              /* actual length of str */
    char *str=NULL;          /* storage for output string */
    int errnum;              /* error number */

    if (_risready(rp, R_WRITE)) {
        if (endcol >= begcol && begcol >= rcolno(rp)) {
            rfldno(rp)++;
            rflags(rp) &= ~_R_TXT;

            /* if colno < begcol, pad with spaces */
            while (rcolno(rp) < begcol) {
                if (_rputc(rp, ' ')) goto done;
            }

            /* put time into formatted string */
            maxsize = strlen(rtmfmt(rp));  /* arbitrary initial max size   */
            do {                           /* loop until max size adequate */
                maxsize += 16;             /* arbitrary max size increment */
                do {                       /* loop until memory allocated  */
                    str = (char *) realloc(str, maxsize+1);
                    if (!str) {
                        errnum = rseterr(rp, R_ENOMEM);
                        if (errnum) goto done;
                    }
                } while (!str);
                len = strftime(str, maxsize, rtmfmt(rp), &t);
            } while (!len);
    
            /* if str fits within the space, output it */
            if (len <= (endcol-begcol+1)) {
                if (fputs(str, rfp(rp)) != EOF) { 
                    rcol(rp) += len;
                    /* pad remainder of space */
                    while (rcolno(rp) <= endcol) {
                        if (_rputc(rp, ' ')) goto done;
                    }
                } else {
                    rseterr(rp, R_ENOPUT);
                }
            /* else converted string too long for space */
            } else {
                rsetwarn(rp, R_WWIDTH);
                while (rcolno(rp) <= endcol) {
                    if (_rputc(rp, '*')) goto done;
                }
            }
        } else {
            rseterr(rp, R_EINVAL); \
        }
    }
done:
    free(str);
    return;
}

/****************************************************************************/
void                         /* returns nothing                             */
    rcputt(                  /* put time to record stream                   */
        REC *rp,             /* record pointer                              */
        size_t begcol,       /* field inclusive beginning column            */
        size_t endcol,       /* field inclusive ending column               */
        time_t time)         /* time                                        */
/****************************************************************************/
{
    rcputtm(rp, begcol, endcol, timetotm(time));
}
