/* This example installs a signal handler routine for SIGFPE,
   catches an integer overflow condition, makes an adjustment
   to AX register, and returns.  This example program MAY cause
   your computer to crash, and will produce runtime errors
   depending on which memory model is used.
*/

/*/ Notes:
  - QLIB has some slight modifications to the Borland C++ signal() extensions
    Please read \txt\signal.txt for details.
  - Warning : using much code (like using printf() below) in an exception
    handler should not be done because the DPMI server may provide a 'very'
    small stack.  As for this example it seems to work ok.  But be warned!
/*/

#pragma inline
#include <system.h>

#ifdef __cplusplus
   typedef void (*fptr)(int);
#else
   typedef void (*fptr)();
#endif


void Catcher(int sig,int subcode,int *reglist)
{
   if ((sig==SIGFPE)&&(subcode==FPE_INTOVFLOW)) {
     printf("Caught it!\n");  //this is dangerous!
//     *(reglist + 8) = 3; /* make AX = 3 */ //Will not work since it does not use stack!
     asm mov eax,reglist
     asm mov ss:[eax + 8*4],dword ptr 3   //must use Stack!
   }
}

int main(void)
{
   word result;
   signal(SIGFPE, (fptr)Catcher);  /* cast Catcher to appropriate type */
   asm     mov     ax,07FFFh       /* AX = 32767 */
   asm     inc     ax              /* cause overflow */
   asm     into                    /* activate handler */

   /* The handler set AX to 3 on return. If that hadn't happened,
      there would have been another exception when the next 'into'
      was executed after the 'dec' instruction. */
   asm     dec     ax              /* no overflow now */
   asm     into                    /* doesn't activate */
   asm     mov     result,ax       // store result
   printf("Result = %d\n",result);
   return 0;
}
