#include <qlib.h>
#include <dpmi.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <process.h>

// Demonstrates how to use DPMI 'C' Wrapper

//REM this to stop Rmode handling
#define dorm

//REM this to stop Pmode handling
#define dopm

#define speed 1
  // 9 ~= 1/2 sec/dot
  // 18 ~= 1 sec/dot

void (*old_handler)(void);

byte ch=0;
volatile byte pmtick=0;
volatile byte rmtick=0;

void new_handler_pm(void) {
  pmtick++;
  outp(0x20,0x20);   //reset IRQ chip
}

void new_handler_rm(void) {
  rmtick++;
  outp(0x20,0x20);   //reset IRQ chip
}

void main(void) {

  sdword a;
  struct callstruct cs;
  struct pmPROCstruct pm;
  struct pmPROCstruct opm;
  struct rmPROCstruct rm;
  struct rmPROCstruct orm;

//setup Real mode IRQ#0 handler
#ifdef dorm
  a=_DPMI_wrapper_cb_iret(new_handler_rm);
  if (a==-1) {
    printf("_DPMI_wrapper_cb_iret() failed\n");
    exit(0);
  }
  pm._sel=selcode;
  pm._off=a;
  a=_DPMI_callback_alloc(&rm,&pm,&cs);
  if (a==-1) {
    printf("_DPMI_callback_alloc() failed\n");
    exit(0);
  }
  _DPMI_getrmint(8,&orm);
  _DPMI_setrmint(8,&rm);
#endif

//setup Protected mode IRQ#0 handler
#ifdef dopm
  a=_DPMI_wrapper_int(new_handler_pm);
  if (a==-1) {
    printf("_DPMI_wrapper_int() failed\n");
    exit(0);
  }
  pm._sel=selcode;
  pm._off=a;
  _DPMI_getpmint(8,&opm);
  _DPMI_setpmint(8,&pm);
#endif

  printf(" '.' = PMODE INT serviced   ',' = RMODE INT serviced\n");
  printf("Press ESC to quit - ");
  while (ch!=27) {
    if (pmtick>speed) {printf(".");pmtick-=speed;}
    if (rmtick>speed) {printf(",");rmtick-=speed;}
    if (kbhit()) ch=getch();
  }

#ifdef dorm
  _DPMI_setrmint(8,&orm);
  _DPMI_callback_free(&rm);
#endif
#ifdef dopm
  _DPMI_setpmint(8,&opm);
#endif

}

