;PMODE/W v1.31+ (DOS/4GW or WDOSX) startup code

_QLIB_C0_ASM_ equ 0   ;used in src\qlib.inc to indicate this is C0.ASM

include src\qlib.inc
include src\ver.inc
include src\video.inc
include flags.inc
include stddef.inc
include dos.inc
include string.inc
include math.inc
include conio.inc
include stdlib.inc
include stdio.inc
include errno.inc
include process.inc
include dpmi.inc
include float.inc
include signal.inc

_QLIB_CFG_ segment dword public use32 'CODE' ;the 1st segment
align 4
externdef _first_byte:byte
_first_byte label byte
db 'QLIB_MEM'   ;this MUST stay here! (used by qsetup)
                ;I place in code so it will be near beginning of EXE file
HEAP_MAX dd -1         ;max that will be alloced for heap
  ;NOTE:you should use pmwsetup to modify how much RAM the DOS extender
  ; allocs.  The values here will have no effect how much it allocs unless
  ; you are running under a DPMI server.  In which case pmwsetup has no
  ; effect.  So use QSETUP which will modify these values directly in the
  ; EXE file which will guaranty you that RAM is avail for spawn...()
  ; and other system calls
HEAP_MIN dd (32 * 1024)   ;min size needed to run
  dd offset _ver
  dd 0
_ver db ver_str,0       ;Version
_QLIB_CFG_ ends

.code
NULLPROC proc
  xor eax,eax
  ret
NULLPROC endp

ERRORPROC proc
  mov eax,ERROR
  ret
ERRORPROC endp

.data
  externdef _baseram:dword
  _baseram dd 0 ;RAM base (relative)
  _argv dd offset _args  ; this is argv!
  _args dd 64 dup (0)    ; the pointers
  rational db 'RATIONAL DOS/4G',0
  qdebug db 'QDEBUG',0
  errno dw 0
  _8087 db 3h            ; (for WATCOM compatibility) FIXED : v2.00 Beta #4
  _ansi_sys db 0         ;ANSI.SYS loaded?
  _lfn db 0              ;Long File Name support available?
  _cpuid db 0            ;CPUID instruction available?
  _mmx db 0              ;MMX present?
  _debugger db 0         ;if currently using WD or QDebug
  _qdebug db 0           ;QDebug detected
  _cpl db 0              ;CPL (0 or 3)
  _qlib_video_cleanup dd offset NULLPROC
                         ;used by QLIB's video and exit/cleanup stuff
  _ds_ dw 0  ; both loaded into Sregs during int 10h
  _es_ dw 0  ; Use these to send info to int 10h
             ; there is an 8k buffer alloc during init for this purpose
             ; it's _8kbufferseg (linear addr=_8kbuffer)

.stack ;this is not the default '.stack' thingy! (see src\qlib.inc)
  db (16*1024) dup (?) ;default 16K stack

.data?  ;starts DWORD aligned
  _handle dd ?  ;RAM handle
  _argstr db 128 dup (?) ; arguments copied from PSP
  _filename dd ?         ;pts to filename as loaded (also @ _argv[0*4])
  _8kbuffer dd ?         ;linear addr of 8k buffer
  selcode dw ?           ;selctor for code
  seldata dw ?           ; " for data
  _environ dd ?          ; environment offset
  _psp dd ?              ; PSP linear offset
  _dta dd ?              ; DTA linear offset
  _pspsel dw ?           ; PSP selector  NEW : v2.11 Beta #5
  _pic_master dw ?       ;PIC Master Base vector
  _pic_slave dw ?        ;PIC Slave Base vector
  public argc
  argc label byte           ;needed for Watcom
  _argc db ?,?,?,?       ; # of arguments  (4 - DWORD push needed later)
  _int_10h df ?   ;df=6 bytes(for sel:offset)
  _int_21h df ?
  _int_1bh df ?
  _int_23h df ?
  _int_33h df ?
  _int dw ? ;interrupt # to call
  _saved_ints db 1024 dup (?) ;saved RM ints

  _8kbufferseg dw ?      ;segment of 8k temp buffer (use as you like!)
  _pmmode db ?           ;mode  1=raw 2=XMS 4=VCPI 8=DPMI
  _fpu db ?              ;80387 FPU?  0=no 1=yes
  _os_typ db ?           ;OS detected (see os.inc)
  _os_ver_major db ?     ;OS version
  _os_ver_minor db ?
  _dos_ver_major db ?    ;DOS version
  _dos_ver_minor db ?
  _cpu label byte
  _processor db ?  ;3=386 4=486 5=586 ...

  _dosXver dw ?    ;DOS extender version  (if possible)
  _dosXtyp db ?    ;DOS extender type (see qlib_def.inc)

  _stdin db (BUFSIZ + sizeof(FILE)) dup (?)
  _stdout db (BUFSIZ + sizeof(FILE)) dup (?)
  _stderr db (BUFSIZ + sizeof(FILE)) dup (?)
  _stdaux db (BUFSIZ + sizeof(FILE)) dup (?)
  _stdprn db (BUFSIZ + sizeof(FILE)) dup (?)

include mem.asm
include os.asm 
include math.asm
include stream.asm
include text.asm
include cpu.asm

.code

__qlib_errors label dword
  dd offset Cantgetbase
  dd offset Cantsetint
  dd offset Cantgetint
  dd offset Cantgetcb

;Error messages
Cantgetbase:
  mov edx,"DPMI Error:Unable to get selector base.\r\n$"
  jmp @f
Cantsetint:
  mov edx,"DPMI Error:Unable to set INT vects\r\n$"
  jmp @f
Cantgetint:
  mov edx,"DPMI Error:Unable to get INT vects\r\n$"
  jmp @f
Cantgetcb:
  mov edx,"DPMI Error:No Callbacks available\r\n$"
  jmp @f
req131:
  mov edx,"PMODE/W v1.31+ required\r\n$"
@@:
  mov ah,9
  int 21h
  mov ax,4c00h
  int 21h

  ;FIX : v2.11 Beta #5 : This was using an EQU that can cause WLINK to crash
  mov eax,offset signal    ;This is to force SIGNAL.OBJ to be LINKED in

externdef main:near
externdef cstart_:near

align 4
  ;required by Watcom C compiler for some reason but never gets called?
cstart_:
__entry32__:
  jmp short begin
  db 'WATCOM',0  ;keep this here in case you use DOS/4GW.EXE
begin:

  sti
  cld

  mov _pspsel,es   ;NEW : v2.11 Beta #5

  mov ax,ds
  mov es,ax
  mov fs,ax
  mov gs,ax
  mov seldata,ax
  mov selcode,cs

;Detect Processor/PICs  (NEW : v2.11 b2)
  mov ax,400h
  int 31h
;  mov _processor,cl   ;see detect_processor() in cpu.asm
  xor eax,eax
  mov al,dh
  mov _pic_master,ax
  mov al,dl
  mov _pic_slave,ax

  mov ax,0eeffh
  int 31h
  .if eax=='PMDW'
    ;Using PMODE/W
    mov es,seldata  ;restore ES
    mov _dosXtyp,DOSX_PMODEW
    mov _pmmode,ch
    mov _dosXver,dx
    cmp dx,100h+31
    jb req131
  .elseif eax=='WDSX'   ;NEW : v2.11 b4 : WDOSX finally supports detection
    ;Using WDOSX v0.94+
    mov _dosXtyp,DOSX_WDOSX
    mov _pmmode,ch
    mov _dosXver,dx
  .else
    mov _pmmode,SRV_UNKNOWN   ;server now undetectable
    mov ax,0a00h   ;detect DOS/4GW
    mov esi,offset rational
    int 31h
    mov ds,cs:seldata   ;restore all sregs
    mov es,seldata
    .if !carry?
      ;Using DOS/4GW
      mov _dosXtyp,DOSX_DOS4GW
      mov _dosXver,0
      mov _debugger,1   ;allow INT 3 for WD (DOS/4GW will simply ignore them)
    .else
      ;DOS extender unknown
      mov _dosXtyp,DOSX_UNKNOWN
      mov _dosXver,0
    .endif
  .endif
  mov ax,0a00h   ;detect QDEBUG.EXE
  mov esi,offset qdebug
  stc   ;just in case
  int 31h
  mov ds,cs:seldata   ;Restore sregs
  mov es,seldata
  .if (!carry?) && (eax=='QBUG')
    ;Using QDebug
    mov _debugger,1
    mov _qdebug,1
  .endif
  mov ax,ds   ;may be modified from INT 31/0a00h
  mov fs,ax
  mov gs,ax

  mov ax,6
  mov bx,_pspsel
  int 31h
  .if carry?
    jmp Cantgetbase
  .endif

  shl ecx,16
  mov cx,dx
  mov _psp,ecx

  mov bx,[ecx+44]  ;get enviroment selector
  mov ax,6
  int 31h
  .if carry?
    jmp Cantgetbase
  .endif

  shl ecx,16
  mov cx,dx
  mov _environ,ecx

  mov ah,1ah
  mov edx,_psp
  add edx,80h
  mov _dta,edx
  int 21h  ;set DTA addr

  mov ax,100h   ;alloc 8k DOS memory for temp buffer
  mov bx,8*1024/16
  int 31h
  jc outofram  ;within mem.asm

  ;ax=RMODE segment
  xor ecx,ecx
  mov cx,ax
  shl ecx,4
  mov _8kbufferseg,ax
  mov _8kbuffer,ecx

;ANSI.SYS detection
  mov ax,1a00h
  int 2fh
  mov _ansi_sys,al    ;0ffh = installed     0 = not installed

;save ALL RM INTS
  mov esi,0   ;the real mode INT table
  mov edi,offset _saved_ints
  mov ecx,256
  rep movsd   ;save 1024 bytes!!!

;save selected PM ints
;  mov ax,204h
;  mov bl,21h
;  int 31h
;  jc Cantgetint
;  mov wptr[_int_21h+4],cx
;  mov dptr[_int_21h+0],edx

  mov ax,204h
  mov bl,10h
  int 31h
  jc Cantgetint
  mov wptr[_int_10h+4],cx
  mov dptr[_int_10h+0],edx

  mov ax,204h
  mov bl,1bh
  int 31h
  jc Cantgetint
  mov wptr[_int_1bh+4],cx
  mov dptr[_int_1bh+0],edx

  mov ax,204h
  mov bl,23h
  int 31h
  jc Cantgetint
  mov wptr[_int_23h+4],cx
  mov dptr[_int_23h+0],edx

  mov ax,204h
  mov bl,33h
  int 31h
  jc Cantgetint
  mov wptr[_int_33h+4],cx
  mov dptr[_int_33h+0],edx

;set PM ints
  mov ax,205h
  mov bl,10h
  mov edx,offset _int10h
  mov cx,cs
  int 31h
  jc Cantsetint

;init all necessary stuff
  call math_init
  .if eax==ERROR
    mov _fpu,0
  .else
    mov _fpu,3
  .endif

  call _fpreset  ;setup FPU as wanted

  include args.asm  ;setup args

  call stream_init   ;FIX : v2.11 Beta #1 : No longer requires malloc()
  call mem_init
  call text_init

  call detect_processor
  mov _processor,al
  call detect_os
  call detect_lfn
  call detect_cpl
  call detect_cpuid
  call detect_mmx

  call call_init

  xor eax,eax
  xor ebx,ebx
  xor ecx,ecx
  xor edx,edx
  xor ebp,ebp
  xor esi,esi
  xor edi,edi

  _brkpt_  ;call debugger if loaded

;main()
  push _environ
  push _argv
  push dptr _argc
  call main  ;called as main(_argc,_argv,_environ)
  add esp,12
;main()

  push ax
  call exit
;end of __entry32__

_c_exit proc
;restore all RM ints
  mov esi,offset _saved_ints
  mov edi,0
  mov ecx,256
  rep movsd

;restore PM ints
  mov ax,205h
  mov bl,10h
  mov cx,wptr[_int_10h+4]
  mov edx,dptr[_int_10h+0]
  int 31h
  jc Cantsetint

;  mov ax,205h
;  mov bl,21h
;  mov cx,wptr[_int_21h+4]
;  mov edx,dptr[_int_21h+0]
;  int 31h
;  jc Cantsetint

  call call_exit  ;deinit everything  (also calls global deconstructors)

  ret
_c_exit endp

include int10.asm
include init.asm
include lfn.asm
include detect.asm

_endseg

end __entry32__
