; Long file support
; Find first/Find Next functions
; Please refer to \txt\lfn.txt for help
; NEW : v2.11 Beta #2 :
;   Added lfn_open(), lfn_rmdir(), lfn_mkdir(), lfn_chdir, lfn_getcwd()
;         lfn_getdcwd(), lfn_unlink(), lfn_creat(), lfn_rename()
;   See \txt\lfn.txt for more info.
include src\qlib.inc
include dos.inc
include string.inc
include stdio.inc

.code

lfn_findfirst proc,str1:dword,allow_attr:byte,req_attr:byte,datetyp:word,lfn_ffb:dword
  .if !_lfn
    mov eax,ERROR
    ret
  .endif

  pushad

  sub esp,sizeof callstruct
  mov [esp].callstruct._eax,714eh  ;Find First
  mov al,allow_attr
  mov bptr[esp+0].callstruct._ecx,al
  mov al,req_attr
  mov bptr[esp+1].callstruct._ecx,al
     ;CL = allowable masks (same as ax=4301h, bits 0,5 ignored)
     ;CH = required masks  (same as CL)
  mov ax,_8kbufferseg
  mov [esp].callstruct._ds,ax       ;DS:DX = search string
  mov [esp].callstruct._edx,0
  mov [esp].callstruct._es,ax       ;ES:DI = data buffer
  mov [esp].callstruct._edi,800h
  mov ax,datetyp
  and ax,1
  mov wptr[esp].callstruct._esi,ax  ;SI = flag (0=64bit date   1=MS-DOS date)
  mov [esp].callstruct._flg,0       ;Must always clear flags before call
  mov dptr[esp].callstruct._sp,0  ;FIX : v2.11 Beta #3 : clear SS:SP 

  mov esi,str1
  mov edi,_8kbuffer
  callp strlen,esi
  inc eax
  mov ecx,eax
  copyECX  ;destroys AL

  mov edi,esp
  mov ax,300h
  xor ecx,ecx
  mov bx,21h     ;INT 21h/ax=714eh
  int 31h
  jc failed

  test [esp].callstruct._flg,1
  jnz failed        ;Carry set?

  xor eax,eax
  mov ax,wptr[esp].callstruct._eax    ;Win95 FindFile handle

success:
  mov esi,_8kbuffer
  add esi,800h
  mov edi,lfn_ffb
  mov ecx,sizeof lfn_ffblk
  _copyECX bl

  add esp,sizeof callstruct
  mov [esp+7*4],eax   ;Save EAX onto stack (handle)
  popad
  ret

failed:
  add esp,sizeof callstruct
  popad
  mov eax,ERROR
  ret
lfn_findfirst endp

lfn_findnext proc,hand:word,datetyp:word,lfn_ffb:dword
  .if !_lfn
    mov eax,ERROR
    ret
  .endif

  pushad

  sub esp,sizeof callstruct
  mov [esp].callstruct._eax,714fh   ;Find Next
  mov ax,hand
  mov wptr[esp].callstruct._ebx,ax  ;Handle
  mov ax,_8kbufferseg
  mov [esp].callstruct._es,ax       ;ES:DI = data buffer
  mov [esp].callstruct._edi,0h
  mov ax,datetyp
  and ax,1
  mov wptr[esp].callstruct._esi,ax  ;SI = flag (0=64bit date   1=MS-DOS date)
  mov [esp].callstruct._flg,0       ;Must always clear flags before call
  mov dptr[esp].callstruct._sp,0  ;FIX : v2.11 Beta #3 : clear SS:SP 

  mov edi,esp
  mov ax,300h
  xor ecx,ecx
  mov bx,21h     ;INT 21h/ax=714eh
  int 31h
  jc failed

  test [esp].callstruct._flg,1
  jnz failed        ;Carry set?

success:
  mov esi,_8kbuffer
  mov edi,lfn_ffb
  mov ecx,sizeof lfn_ffblk
  copyECX  ;destroys AL

  add esp,sizeof callstruct
  popad
  xor eax,eax
  ret

failed:
  add esp,sizeof callstruct
  popad
  mov eax,ERROR
  ret
lfn_findnext endp

lfn_freefind proc,hand:word
  .if !_lfn
    mov eax,ERROR
    ret
  .endif

  pushad

  sub esp,sizeof callstruct
  mov [esp].callstruct._eax,71a1h   ;Find Next
  mov ax,hand
  mov wptr[esp].callstruct._ebx,ax  ;Handle
  mov [esp].callstruct._flg,0       ;Must always clear flags before call
  mov dptr[esp].callstruct._sp,0  ;FIX : v2.11 Beta #3 : clear SS:SP 

  mov edi,esp
  mov ax,300h
  xor ecx,ecx
  mov bx,21h     ;INT 21h/ax=714eh
  int 31h
  jc failed

  test [esp].callstruct._flg,1
  jnz failed        ;Carry set?

success:
  add esp,sizeof callstruct
  popad
  xor eax,eax
  ret

failed:
  add esp,sizeof callstruct
  popad
  mov eax,ERROR
  ret
lfn_freefind endp

lfn_open proc,strg:dword,acc:word,attr:word
  pushad
  .if (!(acc & O_BINARY)) && (!(acc & O_TEXT))
    mov ax,_fmode
    or acc,ax
  .endif
  .if acc & O_TEXT  ;BUG!
    callp printf,"QLIB Warning:O_TEXT not supported.  Using O_BINARY mode instead!\n"
  .endif

  sub esp,sizeof callstruct
  mov [esp].callstruct._eax,716ch   ;Open/Create file
  xor eax,eax   ;AH = special flags (keep all disabled)
  mov al,bptr[acc]
  mov [esp].callstruct._ebx,eax     ;Access mode
  mov ax,attr
  mov [esp].callstruct._ecx,eax     ;Attr (if creat)
  .if acc & O_TRUNC
    mov ax,2  ;Trunc mode
  .else
    mov ax,1  ;Open mode
  .endif
  .if acc & O_CREAT
    or ax,1 shl 4  ;Create mode
  .endif
  mov [esp].callstruct._edx,eax     ;action flags
  mov [esp].callstruct._edi,1       ;# to append to short-char if ambigous filenames occur
  mov ax,_8kbufferseg
  mov [esp].callstruct._ds,ax       ;-+
  mov [esp].callstruct._esi,0       ;DS:SI = buffer
  mov [esp].callstruct._flg,0       ;Must always clear flags before call
  mov dptr[esp].callstruct._sp,0  ;FIX : v2.11 Beta #3 : clear SS:SP 

  mov esi,strg
  mov edi,_8kbuffer
  callp strlen,esi
  inc eax
  mov ecx,eax
  copyECX  ;destroys AL

  mov ax,300h
  mov edi,esp
  mov bx,21h
  xor ecx,ecx
  int 31h
  jc failed

  test [esp].callstruct._flg,1
  jnz failed        ;Carry set?

success:
  xor eax,eax
  mov ax,wptr [esp].callstruct._eax  ;get handle
  add esp,sizeof callstruct
  mov [esp].callstruct._eax,eax      ;save EAX (handle)
  popad
  ret

failed:
  add esp,sizeof callstruct
  popad
  mov eax,ERROR
  ret
lfn_open endp

lfn_creat proc,strg:dword,acc:word,attr:word
  or acc,O_CREAT or O_TRUNC
  callp lfn_open,strg,acc,attr
  ret
lfn_creat endp

__lfn macro act:REQ,unlink:REQ  ;for chdir,mkdir,rmdir,unlink
  local failed,success
  .if !_lfn
    mov eax,ERROR
    ret
  .endif
  pushad
  sub esp,sizeof callstruct
  mov [esp].callstruct._eax,act     ;action
  mov ax,_8kbufferseg
  mov [esp].callstruct._ds,ax       ;-+
  mov [esp].callstruct._edx,0       ;DS:DX = buffer
if unlink
  mov [esp].callstruct._esi,0       ; for lfn_unlink() : no wildcards allowed
  mov [esp].callstruct._ecx,0       ; for lfn_unlink() : ignored
endif
  mov [esp].callstruct._flg,0       ;Must always clear flags before call
  mov dptr[esp].callstruct._sp,0  ;FIX : v2.11 Beta #3 : clear SS:SP 

  mov esi,strg
  mov edi,_8kbuffer
  callp strlen,esi
  inc eax
  mov ecx,eax
  copyECX  ;destroys AL

  mov ax,300h
  mov edi,esp
  mov bx,21h
  xor ecx,ecx
  int 31h
  jc failed

  test [esp].callstruct._flg,1
  jnz failed        ;Carry set?

success:
  add esp,sizeof callstruct
  popad
  xor eax,eax
  ret

failed:
  add esp,sizeof callstruct
  popad
  mov eax,ERROR
  ret
endm

lfn_mkdir proc,strg:dword
  ;DS:DX = directory
  __lfn 7139h,0
lfn_mkdir endp

lfn_rmdir proc,strg:dword
  ;DS:DX = directory
  __lfn 713ah,0
lfn_rmdir endp

lfn_chdir proc,strg:dword
  ;DS:DX = directory
  __lfn 713bh,0
lfn_chdir endp

lfn_unlink proc,strg:dword
  ;DS:DX = filename
  __lfn 7141h,1
lfn_unlink endp

lfn_rename proc,str1:dword,str2:dword
  ;DX:DX = old file/dir name
  ;ES:DI = new name
  .if !_lfn
    mov eax,ERROR
    ret
  .endif
  pushad
  sub esp,sizeof callstruct
  mov [esp].callstruct._eax,7156h
  mov ax,_8kbufferseg
  mov [esp].callstruct._ds,ax       ;-+
  mov [esp].callstruct._edx,0       ;DS:DX = old file/dir buffer
  mov [esp].callstruct._es,ax       ;-+
  mov [esp].callstruct._edi,800h    ;ES:DI = new name buffer
  mov [esp].callstruct._flg,0       ;Must always clear flags before call
  mov dptr[esp].callstruct._sp,0  ;FIX : v2.11 Beta #3 : clear SS:SP 

  mov esi,str1
  mov edi,_8kbuffer
  callp strlen,esi
  inc eax
  mov ecx,eax
  copyECX  ;destroys AL

  mov esi,str2
  mov edi,_8kbuffer
  add edi,800h
  callp strlen,esi
  inc eax
  mov ecx,eax
  copyECX  ;destroys AL

  mov ax,300h
  mov edi,esp
  mov bx,21h
  xor ecx,ecx
  int 31h
  jc failed

  test [esp].callstruct._flg,1
  jnz failed        ;Carry set?

success:
  add esp,sizeof callstruct
  popad
  xor eax,eax
  ret

failed:
  add esp,sizeof callstruct
  popad
  mov eax,ERROR
  ret
lfn_rename endp

__lfn_cwd macro a:REQ,drv:REQ
  .if !_lfn
    mov eax,ERROR
    ret
  .endif
  pushad
  sub esp,sizeof callstruct
  mov [esp].callstruct._eax,a       ;action
  mov ax,_8kbufferseg
  mov [esp].callstruct._ds,ax       ;-+
  mov [esp].callstruct._esi,0       ;DS:SI = buffer
  mov [esp].callstruct._flg,0       ;Must always clear flags before call
  mov [esp].callstruct._edx,drv     ;Drive #  (0=default)
  mov dptr[esp].callstruct._sp,0  ;FIX : v2.11 Beta #3 : clear SS:SP 

  mov ax,300h
  mov edi,esp
  mov bx,21h
  xor ecx,ecx
  int 31h
  jc failed

  test [esp].callstruct._flg,1
  jnz failed        ;Carry set?

success:
  mov esi,_8kbuffer
  mov edi,strg
  callp strlen,esi
  inc eax
  mov ecx,eax
  copyECX  ;destroys AL

  add esp,sizeof callstruct
  popad
  xor eax,eax
  ret

failed:
  add esp,sizeof callstruct
  popad
  mov eax,ERROR
  ret
endm

;Get current working dir.
lfn_getcwd proc,strg:dword
  ;DX:SI = directory
  ;DL = drive (0=default)
  __lfn_cwd 7147h,0
lfn_getcwd endp

;Get Drive's current working dir.
lfn_getdcwd proc,dev:byte,strg:dword
  ;DX:SI = directory
  ;DL = drive
  xor eax,eax
  mov al,dev
  __lfn_cwd 7147h,eax
lfn_getdcwd endp

;NEW : v2.11 Beta #5
lfn_truename proc,dest:dword,src:dword
  ;INT 21h/ax=60h  DS:SI=input  ES:DI=output(128)

  pushad

  callp strlen,src
  cmp eax,260
  ja bad
  inc eax  ;for NULL

  mov esi,src
  mov edi,_8kbuffer
  mov ecx,eax
  copyECX

  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._ss,0  ;clear SS:SP
  mov [esp].callstruct._esi,0
  mov [esp].callstruct._edi,512
  mov ax,_8kbufferseg
  mov [esp].callstruct._ds,ax
  mov [esp].callstruct._es,ax
  mov [esp].callstruct._eax,7160h    ;longname "truename"
  mov [esp].callstruct._ecx,8000h    ;do not expand SUBSTed drives

  mov ax,300h
  mov bx,21h
  xor ecx,ecx
  mov edi,esp   ;ES:EDI = callstruct
  int 31h

  test [esp].callstruct._flg,1
  jnz failed        ;Carry set?

  add esp,sizeof callstruct

  mov esi,_8kbuffer
  add esi,512
  callp strlen,esi
  inc eax  ;for NULL
  mov ecx,eax
  mov edi,dest
  copyECX
  popad
  xor eax,eax  ;SUCCESS
  ret
failed:
  add esp,sizeof callstruct
bad:
  popad
  mov eax,ERROR
  ret
lfn_truename endp

_endseg

end

