include src\qlib.inc
include mem.inc
include video.inc
include string.inc
include conio.inc
include stdio.inc

;text boxes,bars etc.

.code
; Input : cx=x dx=y
; Output : edi=y1*160+x1*2 + 0b8000h
; Destroys : edi
calc macro
  push ax  ;Preserve colors
  xor edi,edi
  mov ax,wptr[_v_xb]  ;=160
  push dx
  mul dx   ;destroy ax,dx
  pop dx
  mov di,cx
  shl di,1
  add di,ax
  add edi,_v_buffer
  pop ax
endm

;Pre-calcuates xl and yl
precalc macro
  dec x1  ;Adjust to (0,0) system
  dec y1
  dec x2
  dec y2
  mov ax,x2
  sub ax,x1
  inc ax
  mov xl,ax
  mov ax,y2
  sub ax,y1
  inc ax
  mov yl,ax
endm

precalc2 macro
  dec x
  dec y
endm

t_boxfill proc x1:word,y1:word,x2:word,y2:word,_char:word
  local xl:word,yl:word

  precalc

  mov dx,y1
f1:  ;for loop 1
  mov cx,x1
  mov bx,xl
  calc
f2:
  mov ax,_char
  stosw
  inc cx
  dec bx
  jnz f2
  inc dx
  dec yl
  jnz f1
  ret
t_boxfill endp

;changes color bytes in box
t_backboxfill proc x1:word,y1:word,x2:word,y2:word,clr:byte
  local xl:word,yl:word

  precalc

  mov dx,y1
f1:  ;for loop 1
  mov cx,x1
  mov bx,xl
  calc
f2:
  inc edi
  mov al,clr
  stosb
  inc cx
  dec bx
  jnz f2
  inc dx
  dec yl
  jnz f1
  ret
t_backboxfill endp

t_box1 proc x1:word,y1:word,x2:word,y2:word,clr:byte
  local wid:dword
  local xl:word,yl:word

  precalc

  xor eax,eax
  mov ax,xl
  dec ax
  shl ax,1
  dec ax
  mov wid,eax

  mov cx,x1
  mov dx,y1
  mov ah,clr
  calc
  mov al,''
  stosw
  inc cx

  mov al,''
  mov bx,xl
@@:
  stosw
  inc cx
  dec bx
  jnz @b
  
  mov al,''
  stosw
  inc dx
  
  mov cx,x1
  mov bx,xl
  mov al,''
@@:
  calc
  stosw
  add esi,wid
  stosw
  inc dx
  dec yl
  jnz @b
  
  calc
  mov al,''
  stosw
  inc cx
  mov bx,xl
@@:  
  mov al,''
  stosw
  inc cx
  dec bx
  jnz @b
  
  mov al,''
  stosw
  ret
t_box1 endp

t_box2 proc x1:word,y1:word,x2:word,y2:word,clr:byte
  local wid:dword
  local xl:word,yl:word

  precalc

  xor eax,eax
  mov ax,xl
  dec ax
  shl ax,1
  dec ax
  mov wid,eax

  mov cx,x1
  mov dx,y1
  mov ah,clr
  calc
  mov al,''
  stosw
  inc cx

  mov al,''
  mov bx,xl
@@:
  stosw
  inc cx
  dec bx
  jnz @b
  
  mov al,''
  stosw
  inc dx
  
  mov cx,x1
  mov bx,xl
  mov al,''
@@:
  calc
  stosw
  add esi,wid
  stosw
  inc dx
  dec yl
  jnz @b
  
  calc
  mov al,''
  stosw
  inc cx
  mov bx,xl
@@:  
  mov al,''
  stosw
  inc cx
  dec bx
  jnz @b
  
  mov al,''
  stosw
  ret
t_box2 endp

t_printxy proc x:word,y:word,s:dword
  precalc2

  pushad
  callp strlen,s
  mov ebx,eax
  mov cx,x
  mov dx,y
  mov esi,s
  mov al,_t_color
newline:
  calc
@@:
  .if bptr[esi]==10
    .if dx < wptr[_t_win_y2]
      inc dx
    .endif
    inc esi
    mov cx,wptr[_t_win_x1]
    dec ebx
    jz done
    jmp newline
  .elseif bptr[esi]==13
    inc esi
    jmp skipchar
  .endif
  movsb
  stosb  ;store text color
skipchar:
  dec ebx
  jnz @b

done:
  popad
  ret
t_printxy endp

t_printf proc x:word,y:word,s:dword,args:vararg
  local siz:dword

  ;DO NOT USE precalc2 here! since I'm calling t_printxy() or it will
  ;  preform calc twice!

  pushad
  lea ebx,args
  callp _vprintf_siz,s,ebx
  mov siz,eax
  sub esp,eax
  mov edx,esp
  callp vsprintf,edx,s,ebx
  callp t_printxy,x,y,edx
  add esp,siz
  popad
  ret
t_printf endp

_endseg

end

