#include <alloc.h>
#include <string.h>
#include <ctype.h>

#define NUM_PARMS (argc>0 ? argc-1:0)
#define IS_SWITCH(c) (((c)=='/')||((c)=='-'))

typedef char (*t_parmarray[20]);            // 20 parms of variable length...

byte num_switches,                          // switch type parameters (prefix / or -)
     num_parms;                             // other parameters
byte ignorecase=0;                          // ignore case?

t_parmarray switches;                       // this holds all the switch parms...
t_parmarray parms;                          // ...and this holds all the other parms

void cl_init(int argc,char *argv[])
{
  byte curparm;                             // current parm # being parsed

  if(NUM_PARMS==0) return;

  num_switches=num_parms=0;
  for(curparm=1;curparm<=NUM_PARMS;curparm++)
  {
    if(IS_SWITCH(argv[curparm][0]))
    {
      switches[num_switches]=(char *) malloc(strlen(argv[curparm]));
      strcpy(switches[num_switches],&argv[curparm][1]);
      num_switches++;
    } else
    {
      parms[num_parms]=(char *) malloc(strlen(argv[curparm])+1);
      strcpy(parms[num_parms],argv[curparm]);
      num_parms++;
    }
  }
};

char *upstr(char *s)
{
  static char z[255];

  strncpy(z,s,255);
  strupr(z);
  return z;
};

byte cl_numparms()
{
  return num_parms;
};

byte cl_numswitches()
{
  return num_switches;
};

char *cl_getparm(byte n)
{
  if(num_parms<1||n>num_parms||n<1) return NULL;
  return parms[n-1];
};

sdword cl_numgetparm(byte n)
{
  if(num_parms<1||n>num_parms||n<1) return ERROR;

  if(strlen(parms[n-1])<3) return str2num(parms[n-1],10);
  if(parms[n-1][0]=='0')
  {
    switch(parms[n-1][1])
    {
      case 'x':
      case 'X':return str2num(&parms[n-1][2],16);
      case 'b':
      case 'B':return str2num(&parms[n-1][2],2);
      case 'o':
      case 'O':return str2num(&parms[n-1][2],8);
    }
  }
  return str2num(parms[n-1],10);
};

byte cl_parmthere(char *s)
{
  byte c;

  if(num_parms<1) return 0;

  if(ignorecase) strupr(s);
  for(c=0;c<num_parms;c++)
  {
    if(ignorecase)
    {
      if(strcmp(s,upstr(parms[c]))==0) return c+1;
    } else
    {
      if(strcmp(s,parms[c])==0) return c+1;
    }
  }
  return 0;
};

byte cl_switchnum(char fl)
{
  byte c;

  if(num_switches<1) return 0;
  fl=toupper(fl);
  for(c=0;c<num_switches;c++)
  {
    if(ignorecase)
    {
      if(toupper(switches[c][0])==fl) return c+1;
    } else
    {
      if(switches[c][0]==fl) return c+1;
    }
  }
  return 0;
};

char *cl_getfullswitch(byte n)
{
  if(num_switches<1||n>num_switches||n<1) return NULL;
  return switches[n-1];
};

byte cl_fullswitchnum(char *s)
{
  byte c;

  if(num_switches<1) return 0;
  if(ignorecase) strupr(s);
  for(c=0;c<num_switches;c++)
  {
    if(ignorecase)
    {
      if(strcmp(upstr(cl_getfullswitch(c+1)),s)==0)return c+1;
    } else
    {
      if(strcmp(cl_getfullswitch(c+1),s)==0)return c+1;
    }
  }
  return 0;
};

char *cl_strswitchparm(byte n)
{
  if(num_switches<1||n>num_switches||n<1) return NULL;
  return &switches[n-1][1];
};

sdword cl_numswitchparm(byte n)
{
  if(num_switches<1||n>num_switches||n<1) return ERROR;

  if(strlen(switches[n-1])<4) return str2num(&switches[n-1][1],10);
  if(switches[n-1][1]=='0')
  {
    switch(switches[n-1][2])
    {
      case 'x':
      case 'X':return str2num(&switches[n-1][3],16);
      case 'b':
      case 'B':return str2num(&switches[n-1][3],2);
      case 'o':
      case 'O':return str2num(&switches[n-1][3],8);
    }
  }
  return str2num(&switches[n-1][1],10);
};
