; Do not include this file in your programs!!!
; It will be included by qlib.inc already!!!

.code
_brkpt_ macro
  .if _debugger
    int 3  ;call debugger if loaded
  .endif
endm

_int3_ proto   ;Same thing as _brkpt_ macro except this is a func (for C)

irq_enable proto irqn:byte
irq_disable proto irqn:byte

pack_open proto strg:dword,:vararg  ;opens a packed file (PAK or PAH)
  ;vararg = header offset if it's a PAH file
pack_close proto :word

NULLPROC proto    ;always returns 0
ERRORPROC proto   ;always returns -1

.data
externdef _os_typ:byte
externdef _os_ver_major:byte
externdef _os_ver_minor:byte
externdef _dos_ver_major:byte
externdef _dos_ver_minor:byte
externdef _dosXver:word   ;version (BCD coded)
externdef _dosXtyp:byte   ;DOS extender type
  DOSX_PMODEW equ 0
  DOSX_DOS4GW equ 1
  DOSX_DOS32 equ 2        ;not implemented any more
  DOSX_WDOSX equ 3
  DOSX_UNKNOWN equ 255
externdef errno:word
externdef selcode:word
externdef seldata:word
externdef _environ:dword    ;relative addr
externdef _psp:dword        ;relative addr to PSP
externdef _dta:dword        ;relative addr to DTA  (it's not in your PSP)
externdef _fpu:byte         ;80387?
externdef _8087:byte        ;WATCOM support
externdef _argstr:byte ;129 dup (?)
externdef _argv:dword ;64 dup (?)
externdef _argc:byte
externdef _pmmode:byte
  SRV_UNKNOWN equ 0ffh
  SRV_DPMI equ 3
  SRV_VCPI equ 2
  SRV_XMS equ 1
  SRV_RAW equ 0
externdef _filename:dword
externdef _ds_:word
externdef _es_:word
externdef _pic_master:word
externdef _pic_slave:word
externdef _8kbufferseg:word
externdef _8kbuffer:dword
externdef _processor:byte  ; processor type : 3=386 4=486 5=586
externdef _cpu:byte        ; processor type : same
externdef _ansi_sys:byte   ; Ansi.sys loaded?
externdef _lfn:byte        ; LFN support available?
externdef _cpuid:byte      ; CPUID present?
externdef _mmx:byte        ; MMX present?
externdef _cpl:byte        ; CPL (0 or 3)
externdef _debugger:byte   ; Q Debug,WD,DOS/4GW loaded?
externdef _qdebug:byte     ; Q Debug present?
externdef _qlib_video_cleanup:dword
externdef _qlib_info:dword ; Q Version String

dma_s struct
  siz dd ?      ;00h    DWORD   region size
  off dd ?      ;04h    DWORD   offset
  sel dw ?      ;08h    WORD    segment/selector
  id dw ?       ;0Ah    WORD    buffer ID
  phys dd ?     ;0Ch    DWORD   physical address
  dmach dw ?    ; This is used by QLIB only!
dma_s ends

dma_alloc64 proto dmas:dword  ;max=64k
dma_alloc128 proto dmas:dword ;max=128k
dma_free proto dmas:dword
dma_setup proto :dword,:dword,:dword,:byte

DMA_MODE_WRITE  equ 048h    ;Write to device from memory (playback)
DMA_MODE_READ   equ 044h    ;Read from device to memory (recode)
DMA_MODE_AUTO   equ 010h    ;Auto. init. DMA mode

;Win95+ funcs
win95_title_set proto :dword
win95_title_get proto :dword,:dword
win95_vmtitle_set proto :dword
win95_vmtitle_get proto :dword,:dword
win95_close_enable proto
win95_close_disable proto
win95_close_query proto
win95_close_ack proto
win95_close_cancel proto

WIN95_CLOSE_NOACK equ 0
WIN95_CLOSE_ACK equ 1

