#ifndef __STDDEF_H__
#define __STDDEF_H__

/*/ New Age typedefs - please use them /*/
typedef unsigned char uint8;
typedef unsigned short int uint16;
typedef unsigned long int uint32;
typedef signed char sint8;
typedef signed short int sint16;
typedef signed long int sint32;
typedef signed char int8;              //same as last 3
typedef signed short int int16;
typedef signed long int int32;
typedef float float32;
typedef double float64;
typedef long double float80;

/* Below is different than from 16bit C typedefs */
typedef unsigned char byte;
typedef unsigned short int word;
typedef unsigned long int dword;
typedef signed char sbyte;
typedef signed short int sword;
typedef signed long int sdword;

typedef unsigned int size_t;
#define NULL (0)
#define SUCCESS (0)
#define ERROR (-1)  //FIX : v2.11 Beta #6 : !SUCCESS == 1 not -1
#define EOF (-1)

//enable Watcom underscore appending
// NEW : v2.10 : Also force Watcom to return double in st(0)
#ifdef __WATCOMC__
  #pragma aux default "_*" parm caller [] \
    value struct routine [eax 8087] \
    modify [eax];
//Change asm to _asm for Watcom v11.0
  #define asm _asm
#endif

//48bit PMODE procedure pointer
// NEW in v2.07 used by setvect, getvect, callback_alloc
struct pmPROCstruct {
  word _sel;
  dword _off;
};

//32bit RMODE function pointer
struct rmPROCstruct {
  word _seg;
  word _off;
};

//this is used with DPMI funcs #30x  (callbacks and calling RMODE)
struct callstruct {    //50 bytes  (32h)
  dword edi;     //0
  dword esi;     //4
  dword ebp;     //8
  dword res;     //reserved
  dword ebx;     //0ch
  dword edx;     //10h
  dword ecx;     //14h
  dword eax;     //18h
  word flg;     //20h flags
  word es;      //22h segments (NOT selectors)
  word ds;      //24h "
  word fs;      //26h "
  word gs;      //28h "
  word ip;      //2ah ignored in some calls
  word cs;      //2ch "
  word sp;      //2eh must be 0 to use system stacks
  word ss;      //30h "
};

#endif

