// QLIB's complete DPMI C callable functions.
#ifndef __DPMI_H__
#define __DPMI_H__

#include <stddef.h>

#ifdef __cplusplus
  extern "C" {
#endif

// 'C' wrappers  (see dpmi.txt for help)

extern dword _DPMI_wrapper_int( void (*)() );
extern dword _DPMI_wrapper_cb_retf( void (*)() );
extern dword _DPMI_wrapper_cb_iret( void (*)() );

// 20xh
extern void _DPMI_getpmint(byte v,struct pmPROCstruct *f);
extern sbyte _DPMI_setpmint(byte v,struct pmPROCstruct *f);
extern void _DPMI_getrmint(byte v,struct rmPROCstruct *f);
extern sbyte _DPMI_setrmint(byte v,struct rmPROCstruct *f);

// 303h and 304h
extern sbyte _DPMI_callback_alloc(struct rmPROCstruct *rf,struct pmPROCstruct *pf,struct callstruct *cb);
  // rf = Rmode addr (returned)
  // pf = Pmode addr (given)
  // cb = callstruct (given)
extern sbyte _DPMI_callback_free(struct rmPROCstruct *rf); 
  // rf = Rmode addr (given)  (this was returned from callback_alloc())

extern dword _DPMI_phys_alloc(dword loc,dword siz);
extern dword _DPMI_phys_free(dword loc);

extern sbyte _DPMI_lock_ram(dword off,dword siz);
extern sbyte _DPMI_unlock_ram(dword off,dword siz);
extern dword _DPMI_lock_all(byte uselockonly);  //returns amount locked

extern word _DPMI_desc_alloc(word n);
extern sbyte _DPMI_desc_free(word n);
extern word _DPMI_seg2desc(word seg);
extern word _DPMI_selinc(void);
extern dword _DPMI_getbase(word sel);
extern sbyte _DPMI_setbase(word sel,dword base);
extern sbyte _DPMI_setlimit(word sel,dword limit);
extern sbyte _DPMI_setrights(word sel,word rights);
extern word _DPMI_create_alias(word sel);
extern sbyte _DPMI_getdesc(word sel,void *buf);
extern sbyte _DPMI_setdesc(word sel,void *buf);

extern word _DPMI_dos_alloc(word siz);
extern sbyte _DPMI_dos_free(word sel);
extern sbyte _DPMI_dos_resize(word sel,word siz);

extern sbyte _DPMI_getexc(byte v,struct pmPROCstruct *pf);
extern sbyte _DPMI_setexc(byte v,struct pmPROCstruct *pf);
extern sbyte _DPMI_do_int(byte v,struct callstruct *cb);
extern sbyte _DPMI_do_call_retf(struct callstruct *cb);
extern sbyte _DPMI_do_call_iret(struct callstruct *cb);

extern word _DPMI_get_raw_state(struct rmPROCstruct *rf, struct pmPROCstruct *pf);
extern word _DPMI_get_raw_switch(struct rmPROCstruct *rf, struct pmPROCstruct *pf);

extern word _DPMI_getver(void);
extern word _DPMI_getflgs(void);
extern byte _DPMI_getcpu(void);
extern word _DPMI_getpics(void);

extern byte _DPMI_cli(void);
extern byte _DPMI_sti(void);
extern byte _DPMI_getIF(void);

// 0xeeff functions only
extern dword _DPMI_detect(struct pmPROCstruct *pf);
extern byte _DPMI_getmode(void);

#ifdef __cplusplus
  }
#endif

#endif

