/***********************************************************/
/* Program Id.               PmnuDemo.C.                   */
/* Author.                   Stan Milam.                   */
/* Date Written.             03/12/89.                     */
/*                                                         */
/* Comments: This program demonstrates the use of the pop- */
/* up menu capabilities of PC Windows.  Use the up & down  */
/* arrow keys to change the selection. Press enter to make */
/* a selection.  Or, press 1 thru 5 to select, or use the  */
/* mouse to "point and shoot".                             */
/***********************************************************/

#include <stdio.h>
#include <pcwproto.h>
#include <menu.h>

int pl_menu_demo(void) {

   WNDPTR *wnd, *savewnd, *iwnd;

/***********************************************************/
/* Create and initialize the pick-list menu values.        */
/***********************************************************/

static char *selections[] = {
    "Methodology",
    "Word Processors",
    "C Compiler",
    "Pascal Compiler",
    "3270 Emulation",
    "Communications",
    "COBOL Compiler",
    "MASM",
    NULL
};

/**********************************************************/
/* PICKLIST contains elements concerning a picklist menu. */
/* First, there is a pointer to the window to be used,    */
/* then window parameters, border parms, title parms,     */
/* selection bar parms, and finally a pointer back to our */
/* menu options.                                          */
/**********************************************************/

    static PICKLIST plmenu =  {
       NULL,
       15, 30, 19, 50, BLACK,LIGHTGRAY,          /* Window Parms */
       2, RED,LIGHTGRAY,                         /* Border Parms */
       " Main Menu ",TOP,MIDDLE,BLUE,LIGHTGRAY,  /* Title  Parms */
       WHITE,BLUE,                               /* Select Bar color  */
       selections,                               /* pointer to menu list */
       0,0                                       /* bar position offset */
    };

    static char *instructions[] = {
       "To use  the Pick  List Menu  use the \30\31 arrow  keys,",
       "to place the cursor  bar on  the  desired  selection",
       "and then press  enter.  Or, use the Mouse  to  point",
       "and shoot the  selection you want.  ESC or the right",
       "Mouse  key will end the demo.   There  may  be  more",
       "picks  than can be shown in the window. You may  use",
       "the arrow  keys or the Mouse to scroll them.        ",
       NULL
    };

   int i = 0;
   int mxr, mxc;

   chk_video_state(&mxr,&mxc);                   /* Get max rows & cols */
   savewnd = wpush(1,1,mxr,mxc);                 /* Save entire screen */
   if (!savewnd) return(3);                      /* Exit if cannot save */
   bordercolor(BLUE,LIGHTGRAY);                  /* Set border color */
   titlecolor(BLACK,LIGHTGRAY);                  /* Set the title color */
   iwnd = wexplode(2,10,12,70,RED,LIGHTGRAY);    /* Make instruction window */
   wtitle(iwnd,TOP,LEFT," Pick List Menu Instructions "); /* Title it */
   w_block_write(iwnd, 2, CENTER,instructions);  /* Write instructions to it */
   wnd = make_pick_list(&plmenu);                /* Make a popup window */
   while (i != -1) {                             /* Do until Esc */
      i = get_pick_list(&plmenu);                /* Get Menu return value */
      if ( i == 27 ) continue;
      if (mpresent) hide_mouse();
      qhchar(22,1,7,BLUE,176,80);                /* Clear msg line */
      qputs(22,99,RED,7,selections[i]);          /* Write the choice */
      if (mpresent) show_mouse();
   }
   if (mpresent) hide_mouse();                   /* Hide the mouse */
   wnd     = wpop(wnd);                          /* Get rid of menu */
   iwnd    = wpop(iwnd);                         /* Get rid of instructions */
   savewnd = wpop(savewnd);                      /* Restore msg row */
   return(0);                                    /* And go home */
}

