/*
 *                               _KB.H
 *
 *                        Keyboard i/o Handler
 *
 *                           Written for the
 *
 *                              Datalight
 *                           Microsoft V 5.x
 *                                TurboC
 *                                  &
 *                               Zortech
 *
 *                             C Compilers
 *
 *            Copyright (c) John Birchfield 1987, 1988, 1989
 */

/* control key translations */

# define CTLX			0x4000
# define META			0x8000
# define up_char		240
# define down_char		241
# define right_char		242
# define left_char		243


# define home_char		META | 69		/* ESC O E   */
# define ctl_home_char	META | 70		/* ESC O F   */
# define pageup_char	META | 71		/* ESC O G  */
# define ctl_pu_char	META | 72		/* ESC O H  */
# define ctl_rt_char	META | 73		/* ESC O I  */
# define pagedown_char	META | 74		/* ESC O J  */
# define ctl_pd_char	META | 75		/* ESC O K  */
# define end_char		META | 76		/* ESC O L  */
# define ctl_end_char	META | 77		/* ESC O M  */
# define ctl_lft_char	META | 78		/* ESC O N  */

# define Ins_char		206
# define Del_char		207
# define NextWord_char	208
# define PrevWord_char	209

# define M1				210
# define M2				211
# define M3				212
# define M4				213
# define M5				214
# define M6				215
# define M7				216
# define M8				217
# define M9				218
# define M10			219
# define M11			220
# define M12			221
# define M13			222
# define M14			223
# define M15			224
# define M16			225
# define M17			226
# define M18			227
# define M19			228
# define M20			229
# define M21			230
# define M22			231
# define M23			232
# define M24			233
# define M25			234
# define M26			235
# define M27			236
# define M28			237
# define M29			238
# define M30			239
# define M31			240
# define M32			241
# define M33			242
# define M34			243
# define M35			244
# define M36			245
# define M37			246
# define M38			247
# define M39			248
# define M40			249


#define	NUL		0
#define	ENQ		5
#define	BEL		7
#define	BS		8
#define	HT		9
#define	LF		10
#define	VT		11
#define	FF		12
#define	CR		13
#define SO		14
#define	SI		15
#define	XON		17
#define	XOFF	19
#define	CAN		24
#define	SUB		26
#define	ESC		27
#define	DEL		127
#define DC2		18
#define DC4		20
#define	TAB		9
#define DEL1	207


/*
	Keyboard input characters after scan code translation
*/

#define PF1			210
#define PF2			211
#define PF3			212
#define PF4			213
#define PF5			214
#define PF6			215
#define PF7			216
#define PF8			217
#define PF9			218
#define PF10		219

#define SPF1		230
#define	SPF2		231
#define	SPF3		232
#define	SPF4		233
#define	SPF5		234
#define SPF6		235
#define SPF7		236
#define	SPF8		237
#define	SPF9		238
#define	SPF10		239
#define APF1		220
#define APF2		221
#define APF3		222
#define APF4		223
#define APF5		224
#define APF6		225
#define APF7		226
#define APF8		227
#define APF9		228
#define APF10		229

#define	HCHAR		200
#define UPCHAR		240
#define	DNCHAR		241
#define	RTCHAR		242
#define	LFCHAR		243
#define INSCHAR		206
#define DELCHAR		207
#define BOLCHAR		200
#define EOLCHAR		201
#define	PGUCHAR		202
#define	PGDCHAR		203
#define	NWCHAR		208
#define	PWCHAR		209

extern int _kb (void);
