#
#            Makefile for various Serial Port Handler Programs
#
#                               8250xxx.*
#
#                             Written for
#                         The Turbo C Compiler
#
#                            CopyRight 1988
#
#                            John Birchfield
#
#
#   MONITOR  - a simple line monitor program
#
#   MDM_INIT - a modem initialization program
#
#   VT100    - self explanitory
#

CFLAGS	=	-mt -K -DSTANDALONE
BINDIR	=	/bin

IOBJS	=	mdm_init.obj 8250xon.obj timer.obj \
			queue.obj ctrl_brk.obj

MOBJS	=	monitor.obj options.obj 8250xon.obj queue.obj \
     		ctrl_brk.obj _kb.obj timer.obj

VOBJS	=	vt100.obj queue.obj screen.obj 8250xon.obj \
     		ctrl_brk.obj _kb.obj timer.obj options.obj


.c.obj : 
	tcc -c $(CFLAGS) $<

all          : drop_dtr laser mdm_init monitor vt100

drop_dtr     : drop_dtr.com

mdm_init     : mdm_init.com

monitor      : monitor.com

vt100        : vt100.com

drop_dtr.com : drop_dtr.obj timer.obj
	tcc $(CFLAGS) -f- drop_dtr.obj timer.obj
	$(BINDIR)/exe2bin drop_dtr.exe drop_dtr.com
	del drop_dtr.exe

mdm_init.com : $(IOBJS)
	tcc $(CFLAGS) -f- $(IOBJS)
	$(BINDIR)/exe2bin mdm_init.exe mdm_init.com
	del mdm_init.exe

monitor.com  : $(MOBJS)
	tcc $(CFLAGS) -f- $(MOBJS)
	$(BINDIR)/exe2bin monitor.exe monitor.com
	del monitor.exe

vt100.com    : $(VOBJS)
	tcc $(CFLAGS) -f- $(VOBJS)
	$(BINDIR)/exe2bin vt100.exe vt100.com
	del vt100.exe

$(MOBJS)     : 

$(VOBJS)     : 

clean        :  
	del *.obj
	del *.map

archive      : 
	$(BINDIR)/chmod -r comm_io.arc
	$(BINDIR)/pkarc -u comm_io *.c *.h  *.asm *.rsp *.cmd makefile.*
	$(BINDIR)/chmod -a *.c *.h *.rsp makefile.*
