include mwutil.ah

_DATA segment
      hiResSet  db 0
      hiResTime dd 0
_DATA ends

_TEXT segment

;---------------------------------------------------------------------------
; void SetHiResTimer (void);
;
; Sets timer 1 to update 65535*18.2 per second (1.193180 MHz)
; Does not affect INT 8 or memory refresh rate

PubProc SetHiResTimer
        cmp hiResSet,0
        jne @exit
        mov al,00110100b           ; timer 1 in mode 2
        out 43h,al
        mov al,0
        out 40h,al
        out 40h,al
@exit:  ret

;---------------------------------------------------------------------------
; unsigned int GetHiResTimer (void);
;
; Return timer value as DWORD in EAX (actually only 6 bytes)

PubProc GetHiResTimer
        xor eax,eax                ; clear result
        out 43h,al                 ; latch counter 0
        in al,40h                  ; read lsb
        mov ah,al                  ; hide LSB in AH
        in al,40h                  ; read msb
        xchg al,ah
        not ax                     ; invert AX (counter counts down)
        push eax
        call Get_BIOS_time
        pop edx
        shl eax,16                 ; make room for AX
        add eax,edx                ; number of 65535*18.2 ticks/sec
        ret                        ; approx 1193 in 1mSec

;---------------------------------------------------------------------------
; unsigned int Get_BIOS_time (void);
;
; Return normal BIOS timer value as DWORD in EAX

PubProc Get_BIOS_time
        push es
        mov ax,SS_DOSMEM
        mov es,ax
        mov eax,es:[46Ch]          ; number of 18.2 ticks since midnight
        pop es
        ret

;---------------------------------------------------------------------------
; unsigned int GetMilliSec (void);
;
; Get # of mSec. Good to approx 14 minutes timings

PubProc GetMilliSec
        call GetHiResTimer         ; get ticks in EAX
        xor edx,edx                ; dividend = 0:EAX
        mov ecx,1193               ; divisor = ECX
        div ecx                    ; EAX = result, EDX = remainder
        ret

;---------------------------------------------------------------------------
; unsigned int StartHiResTimer (void);
;
; Start high-resolution timer and return current hi-res time

PubProc StartHiResTimer
        call GetHiResTimer
        mov hiResTime,eax
        ret

;---------------------------------------------------------------------------
; unsigned int StopHiResTimer (void);
;
; Return number of mSec since last call to StartHiResTimer

PubProc StopHiResTimer
        call GetHiResTimer
        sub eax,hiResTime
        xor edx,edx                ; dividend = 0:EAX
        mov ecx,1193               ; divisor = ECX
        div ecx                    ; EAX = result, EDX = remainder
        mov hiResTime,0
        ret

_TEXT ends

END
