/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details  */
/* Adapted for Metaware High C/C++ & Pharlap by G. Vanem 1997 */

#include "mwutil.h"

void sound (unsigned freq)
{
  int scale;
  if (freq == 0)
  {
    outp (0x61, inp(0x61) & ~3);
    return;
  }
  scale = 1193046 / freq;
  outp (0x43, 0xB6);
  outp (0x42, scale & 0xFF);
  outp (0x42, scale >> 8);
  outp (0x61, inp(0x61) | 3);
}

void soundBell (void)
{
  sound (2000);
  delay (20);
  sound (0);
}

void soundBell_BIOS (void)
{
  SWI_REGS reg;
  reg.eax = 0xE07;
  _dx_real_int (0x10,&reg);
}
