/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */
/* Converts a palette from pal_edit for use with JLib pal_load functions */

#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>


int main(int argc, char **argv)
{
 FILE *output;
 UBYTE *pal;
 int i;

 if(argc != 3) {
    puts("usage: pal_conv <in.pal> <out.pal>\n");
    puts("Converts <in.pal> (output from pal_edit) to <out.pal> for use with JLib");
    exit(0);
 }

 pal=pal_load(argv[1]);

 output=fopen(argv[2],"wb");

 if((pal==NULL)||(output==NULL)){
    puts("pal_conv: File I/O Error.");
 }

 for(i=0;i<SCREEN_NUM_COLORS*3;i++) {
     pal[i]=pal[i]<<2;
     fputc(pal[i],output);
 }

 fclose(output);

 printf("Palette converted to file %s\n",argv[2]);

 return 0;
}
