/*
 * X Version Copyright (C) 1996 Henrik Schmidt
 * 
 * Based on SVGA code by Jonathan Paul Griffiths
 */

#include <jlib.h>

static UBYTE __jlib_mouse_initted=0;


/*+--------------------------------------------------------------------------+ */
/*|check for the presence of a mouse.                                        | */
/*+--------------------------------------------------------------------------+ */
int mouse_present (void)
{

 if(__jlib_mouse_initted){
    return MOUSE_PRESENT;
 }
 
 if ( jxdisplay == NULL || !jxwindow )
   return MOUSE_ABSENT; 
 /* mouse init before video init */


 jxmask |= ( ButtonPressMask | ButtonReleaseMask |
			 LeaveWindowMask | EnterWindowMask ); 

 XSelectInput(jxdisplay,jxwindow,jxmask);

 __jlib_mouse_initted= 1;

 return MOUSE_PRESENT;
}


/*+--------------------------------------------------------------------------+ */
/*|show the pointer                                                          | */
/*+--------------------------------------------------------------------------+ */
void mouse_show_pointer (void)
{
}


/*+--------------------------------------------------------------------------+ */
/*|hide the pointer                                                          | */
/*+--------------------------------------------------------------------------+ */
void mouse_hide_pointer (void)
{
}

/*+--------------------------------------------------------------------------+ */
/*|read pointer coordinates                                                  | */
/*+--------------------------------------------------------------------------+ */

void mouse_get_status(int *x, int *y, int *b_status)
{
XEvent   mevent;
Window	 dummyroot,dummychild;
int      dummyx,dummyy;
unsigned int      dummykey;
static   int button;
static   short in;

  if(!__jlib_mouse_initted){
	return;
  }

   
  if ( XCheckTypedEvent(jxdisplay,ButtonPress,&mevent) )
	button = mevent.xbutton.button;
  /* button can be 1,2 or three on a three button mouse */


  if ( XCheckTypedEvent(jxdisplay,ButtonRelease,&mevent) ) 
	button = 0;

  if ( XCheckTypedWindowEvent(jxdisplay,jxwindow,LeaveNotify,&mevent) ) 
	in = 0;
  /* mouse not in SCREEN window */


  if ( XCheckTypedWindowEvent(jxdisplay,jxwindow,EnterNotify,&mevent) ) 
	in = 1;

  if ( in )
	XQueryPointer(jxdisplay,jxwindow,&dummyroot,&dummychild,&dummyx,
						&dummyy,x,y,&dummykey);
						
  *b_status = button;

}

/*+--------------------------------------------------------------------------+ */
/*|change pointer coordinates.                                               | */
/*+--------------------------------------------------------------------------+ */
void mouse_set_status (int x, int y)
{

  if(!__jlib_mouse_initted){
	return;
  }

  if ( x >= 0 && x < SCREEN_MAX_X && y >=0 && y < SCREEN_MAX_Y ) 
	XWarpPointer(jxdisplay,None,jxwindow,0,0,0,0,x,y);

}


/*+--------------------------------------------------------------------------+ */
/*|shut down the mouse.                                                      | */
/*+--------------------------------------------------------------------------+ */
void mouse_closedown (void)
{
}
