/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <jlib.h>
#include <vga.h>

char version_string[] = "Linux svgalib";
int           __jlib_pages;
static int    __jlib_mode_initted=0;
vga_modeinfo *__jlib_modeinfo;


/*+------------------------------------------------------------------------+ */
/*|set video mode.                                                         | */
/*+------------------------------------------------------------------------+ */
int screen_set_video_mode(void)
{ 
 if(__jlib_mode_initted){
    return 0;
 }

 JLIB_SIGNAL_SETUP; 

 if(!vga_hasmode(JLIB_MODE)){
     return 0;
 } 

 __jlib_modeinfo=vga_getmodeinfo(JLIB_MODE);
 __jlib_pages=(__jlib_modeinfo->height*__jlib_modeinfo->linewidth+65535)>>16;
 
 if(!vga_init()){
     if(!vga_setmode(JLIB_MODE)){
        __jlib_mode_initted=1;
        return 1; /* mode set OK */
     }
 }
 
 return 0;        /* mode set failed */
}


/*+------------------------------------------------------------------------+ */
/*|restore the video mode.                                                 | */
/*+------------------------------------------------------------------------+ */
void screen_restore_video_mode (void)
{
  if(!__jlib_mode_initted){
    return;
  }
  __jlib_mode_initted=0;

  vga_setmode(TEXT);
}


/*+------------------------------------------------------------------------+ */
/*|Return the current page number.                                         | */
/*+------------------------------------------------------------------------+ */
int screen_get_page (void)
{
   return 1;
}


/*+------------------------------------------------------------------------+ */
/*|set the given  page number.                                             | */
/*+------------------------------------------------------------------------+ */
void screen_set_page (int page)
{
 /* do nothing */
}


/*+------------------------------------------------------------------------+ */
/*|Show the current drawing page.                                          | */
/*+------------------------------------------------------------------------+ */
void screen_show_page (int page)
{
   /* do nothing */
}


/*+------------------------------------------------------------------------+ */ 
/*|Wait for the retrace beam to move offscreen.                            | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_wait_vsync (void)
{
   /* not implememted yet */
}


/*+------------------------------------------------------------------------+ */ 
/*|Fill the screen with a given color.                                     | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_fill (UBYTE color) 
{
 int i;
 UBYTE *dest = vga_getgraphmem();

 for(i=0;i<__jlib_pages;i++){
     vga_setpage(i);
     MEM_STORE_LONG(dest,color,65536); 
 }
}


/*+------------------------------------------------------------------------+ */ 
/*|Clear the screen.                                                       | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_clear (void) 
{
 screen_fill(0);
}
