/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <dos.h>
#include <pc.h>
#include <jlib.h>

static int __jlib_mouse_visible; 
static int __jlib_mouse_initted=0;

/*+------------------------------------------------------------------------+ */
/*|check for the presence of a mouse.                                      | */
/*+------------------------------------------------------------------------+ */
int mouse_present(void)
{
   union REGS r;
      
   if(__jlib_mouse_initted){
      return MOUSE_PRESENT;
   }

   __jlib_mouse_initted = 1;

   r.x.ax = 0x0000;
   int86 (0x33, &r, &r);

   if(r.x.ax == 0xffff){
      mouse_show_pointer();   
       return MOUSE_PRESENT;
   }
   else{
	return MOUSE_ABSENT;
   }
}


/*+------------------------------------------------------------------------+ */
/*|show the pointer.                                                       | */
/*+------------------------------------------------------------------------+ */
void mouse_show_pointer (void)
{
   union REGS r;

   if((!__jlib_mouse_initted)||(__jlib_mouse_visible)){
      return;
   }

   r.x.ax= 0x0001;
   int86(0x33, &r, &r);
   
   __jlib_mouse_visible= 1;
}


/*+------------------------------------------------------------------------+ */
/*|hide the pointer.                                                       | */
/*+------------------------------------------------------------------------+ */
void mouse_hide_pointer (void)
{
   union REGS r;

   if((!__jlib_mouse_initted) || (!__jlib_mouse_visible)){
      return; /* do nothing */
   }

   r.x.ax = 0x0002;
   int86 (0x33, &r, &r);
  
   __jlib_mouse_visible= 0;
}


/*+------------------------------------------------------------------------+ */
/*|read pointer coordinates.                                               | */
/*+------------------------------------------------------------------------+ */
void mouse_get_status (int *x_pos, int *y_pos, int *b_status)
{
   union REGS r;

   if(!__jlib_mouse_initted){
      return; /* do nothing */
   }

   r.x.ax = 0x0003;

   int86(0x33, &r, &r);
   *x_pos = (int)(((USHORT)r.x.cx >> 1)&0xffff); /* halve returned coord */
   *y_pos = (int)((USHORT)r.x.dx & 0xffff);
   *b_status = (int)(USHORT)r.x.bx;
}


/*+------------------------------------------------------------------------+ */
/*|change pointer coordinates.                                             | */
/*+------------------------------------------------------------------------+ */
void mouse_set_status (int x, int y)
{
   union REGS r;

   if(!__jlib_mouse_initted){
      return; /* do nothing */
   }

   r.x.ax = 0x0004;
   r.x.cx = x;
   r.x.dx = y;

   int86(0x33, &r, &r);
}


/*+------------------------------------------------------------------------+ */
/*|shut down the mouse.                                                    | */
/*+------------------------------------------------------------------------+ */
void mouse_closedown(void)
{
   if(!__jlib_mouse_initted){
      return; /* don't re-shutdown */
   }

   mouse_hide_pointer();

   __jlib_mouse_initted= 0;
}
