/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */
/* Except for image_save_pcx, see copyright information below. */
#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>

typedef struct PCX_HEADER{
     UBYTE manufacturer;
     UBYTE version;
     UBYTE encoding;
     UBYTE bits_per_pixel;
     SHORT xmin, ymin;
     SHORT xmax, ymax;
     SHORT hres;
     SHORT vres;
     UBYTE palette16[48];
     UBYTE reserved;
     UBYTE color_planes;
     SHORT bytes_per_line;
     SHORT palette_type;
     UBYTE filler[58];
} pcx_header;


image * image_load_pcx (char *filename) 
{
 FILE * in;
 image *foo;

 JLIB_ENTER("image_load_pcx");

 if ((in = fopen (filename, "rb")) == NULL){
     JLIB_SPRINTF("%s File Open Error.",filename);
     JLIB_LEAVE
     return (image *) NULL;
 }

 foo=image_load_pcx_fp (in);

 fclose(in);

 JLIB_LEAVE
 return foo;
}


image * image_load_pcx_fp (FILE *fp) 
{
   image * timg;
   int i, c;
   pcx_header pcxhead;
      
   JLIB_ENTER("image_load_pcx");

   if(fp==NULL){
     jlib_exit(jlib_msg(JLIB_ENULL));
   }

   /* grab mem for header record */ 
   if((timg = (image *) malloc (sizeof (image))) == NULL){
     jlib_exit(jlib_msg(JLIB_EMALLOC));
   }
      
   /* grab mem for palette */ 
   if ((timg->palette = (UBYTE *) malloc (768 * sizeof (UBYTE))) == NULL){
      jlib_exit(jlib_msg(JLIB_EMALLOC));
   }
   
      
   jio_read_elementary_type(fp,&pcxhead.manufacturer,sizeof(UBYTE));
   jio_read_elementary_type(fp,&pcxhead.version,sizeof(UBYTE));
   jio_read_elementary_type(fp,&pcxhead.encoding,sizeof(UBYTE));
   jio_read_elementary_type(fp,&pcxhead.bits_per_pixel,sizeof(UBYTE));
   
   jio_read_elementary_type(fp,&pcxhead.xmin,sizeof(SHORT));
   jio_read_elementary_type(fp,&pcxhead.ymin,sizeof(SHORT));
   jio_read_elementary_type(fp,&pcxhead.xmax,sizeof(SHORT));
   jio_read_elementary_type(fp,&pcxhead.ymax,sizeof(SHORT));
   jio_read_elementary_type(fp,&pcxhead.hres,sizeof(SHORT));
   jio_read_elementary_type(fp,&pcxhead.vres,sizeof(SHORT));

   for(i=0;i<48;i++){
      jio_read_elementary_type(fp,&pcxhead.palette16[i],sizeof(UBYTE));
   }      

   jio_read_elementary_type(fp,&pcxhead.reserved,sizeof(UBYTE));
   jio_read_elementary_type(fp,&pcxhead.color_planes,sizeof(UBYTE));
   jio_read_elementary_type(fp,&pcxhead.bytes_per_line,sizeof(SHORT));
   jio_read_elementary_type(fp,&pcxhead.palette_type,sizeof(SHORT));

   for(i=0;i<58;i++){
      jio_read_elementary_type(fp,&pcxhead.filler[i],sizeof(UBYTE));
   }      
      
   /* set width and height */ 
   timg->width = (int)(pcxhead.xmax - pcxhead.xmin) + 1;
   
   timg->height = (int)(pcxhead.ymax - pcxhead.ymin) + 1;
   
      
   JLIB_SPRINTF("PCX Width: %d.",timg->width);
   JLIB_SPRINTF("PCX Height: %d.",timg->height);
         
   /* grab memory for buffer */ 
   if ((timg->data = (UBYTE *) malloc ((timg->width * timg->height) * sizeof (UBYTE))) == NULL){
      free (timg->palette);
      free (timg);

      jlib_exit(jlib_msg(JLIB_EMALLOC));
     }
   
      
   /* get the RLE data into the buffer */ 
   for(i = 0; i < (timg->width * timg->height);){
        unsigned int x;
	   
        c = fgetc (fp) & 0xff;
        if ((c & 0xc0) == 0xc0){
		x = c & 0x3f;
                c = fgetc (fp);
	     
                while (x--){
                     timg->data[i] = (UBYTE)(c & 0xff);
		     i++;
	       }
          }
          else{
              timg->data[i] = (UBYTE)(c & 0xff);
              i++;
          }
     }
      
   /* Get the check marker for 256-colour files */ 
 /*  fseek (fp, -769L, 2); */
      
   c = fgetc (fp);
   
      
    if(c != 0x0C){
       JLIB_PRINT_DEBUG_INFO ("Checksum incorrect loading pcx file.\n");
       free (timg->data);
       free (timg->palette);
       free (timg);
	
       JLIB_LEAVE
       return (image *) NULL;
    }
   
      
   /* Read in the 256 colour palette */ 
   if ((c = fread (timg->palette, 1, 768, fp)) != 768){
	
	   JLIB_PRINT_DEBUG_INFO ("Palette read failed\n");
	   free (timg->data);
	   free (timg->palette);
	   free (timg);
	
	   JLIB_LEAVE
	   return (image *) NULL;
   }
      
   JLIB_LEAVE

   image_setup(timg);

   /* return a pointer to the image */
   return timg;
}


/* Save Jlib buffers to pcx files
 * (c) by Lennart Steinke
 *
 * This is "mailware": if you're using this stuff, send me a postcard, or
 * email me.
 * Lennart Steinke Hofener Str. 16 74366 Kirchheim/N. GERMANY */

UBYTE create_RLE(UBYTE * data, UBYTE max, UBYTE * rle, UBYTE * value);

int image_save_pcx(char *filename, buffer_rec * buff, UBYTE * pal)
{
 pcx_header header;
 FILE *f;
 int x,y,i;
 UBYTE *data,rle,value,amount;
 USHORT c=0,d=0;

 /* Simple check */
 if((buff==NULL)||(pal==NULL)){
    return 0;
 }

 /* Open file */
 f=fopen(filename, "wb");
 if(f==NULL){
    return 0;
 }

 /* Fill in header info, then write header */
 header.manufacturer = 10;
 header.version = 5;
 header.encoding = 1;
 header.bits_per_pixel = 8;
 header.xmin = 0;
 header.ymin = 0;
 header.xmax = (SHORT)B_MAX_X(buff);
 header.ymax = (SHORT)B_MAX_Y(buff);
 header.hres = (SHORT)B_X_SIZE(buff);
 header.vres = (SHORT)B_Y_SIZE(buff);
 header.reserved = 0;
 header.color_planes = 1;
 header.bytes_per_line = (SHORT)B_X_SIZE(buff);
 header.palette_type = 1;

 jio_write_elementary_type(f,&header.manufacturer,sizeof(UBYTE));
 jio_write_elementary_type(f,&header.version,sizeof(UBYTE));
 jio_write_elementary_type(f,&header.encoding,sizeof(UBYTE));
 jio_write_elementary_type(f,&header.bits_per_pixel,sizeof(UBYTE));
  
 jio_write_elementary_type(f,&header.xmin,sizeof(SHORT));
 jio_write_elementary_type(f,&header.ymin,sizeof(SHORT));
 jio_write_elementary_type(f,&header.xmax,sizeof(SHORT));
 jio_write_elementary_type(f,&header.ymax,sizeof(SHORT));
 jio_write_elementary_type(f,&header.hres,sizeof(SHORT));
 jio_write_elementary_type(f,&header.vres,sizeof(SHORT));

 for(i=0;i<48;i++){
    jio_write_elementary_type(f,&header.palette16[i],sizeof(UBYTE));
 }      

 jio_write_elementary_type(f,&header.reserved,sizeof(UBYTE));
 jio_write_elementary_type(f,&header.color_planes,sizeof(UBYTE));
 jio_write_elementary_type(f,&header.bytes_per_line,sizeof(SHORT));
 jio_write_elementary_type(f,&header.palette_type,sizeof(SHORT));

 for(i=0;i<58;i++){
     jio_write_elementary_type(f,&header.filler[i],sizeof(UBYTE));
 }      

 /* Write data */
 data = B_BUFF_PTR(buff);

 for(y=0;y<header.vres;y++){
     for(x=0;x<header.hres;){
         if((x + 63) < header.hres){
             amount = create_RLE(data, 63, &rle, &value);
         }
         else{
             amount = create_RLE(data,(UBYTE)(header.hres - x), &rle, &value);
         }

         data += amount;
         x += amount;

         if(rle){
            jio_write_elementary_type(f,&rle,sizeof(UBYTE));
            d++;
         }

         jio_write_elementary_type(f,&value,sizeof(UBYTE));
         c++;
     }

 }


 /* Write pal */
 value = 0x0c;    /* Palette recognition byte */
 jio_write_elementary_type(f,&value,sizeof(UBYTE));

 fwrite(&value,sizeof(UBYTE),1,f);

 for(i=0;i<768;i++){
     jio_write_elementary_type(f,&pal[i],sizeof(UBYTE));
 }      

 /* Close file */
 fclose(f);

 return 1;
}


UBYTE create_RLE(UBYTE * data, UBYTE max, UBYTE * rle, UBYTE * value)
{
 UBYTE last=0,amount=0;

  last = *data;
  data++;
  amount++;

  while((last == (*data)) && (amount < max)) {
       data++;
       amount++;
  }

  if(amount==1){
     if(last < 192) {
       *rle=0;
     }
     else{
       *rle=193;                     /* RLE run length 1 */
     }
  }
  else{
     *rle=(UBYTE)(192 + amount);
  }

  *value = last;

  return amount;
}


