/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <stdlib.h>
#include <jlib.h>

/*+------------------------------------------------------------------------+*/ 
/*|free the storage used by an image to the O/S.                           |*/ 
/*+------------------------------------------------------------------------+*/ 
image * image_free (image * img) 
{
 JLIB_ENTER("image_free");
   
 if(img != NULL){
   if(img->data != NULL){
      free(img->data);
   }
   free(img);
 }
      
 JLIB_LEAVE;
 return NULL;
}

/*+------------------------------------------------------------------------+*/ 
/*|Set up a fake buffer for an image                                       |*/ 
/*+------------------------------------------------------------------------+*/ 
void image_setup(image * img)
{
   int height;
   UBYTE *ptr,**index;

   JLIB_ENTER("image_setup");

   img->buff = (buffer_rec *) malloc(sizeof(buffer_rec));

   if(img->buff == NULL) {
      jlib_exit(jlib_msg(JLIB_EMALLOC));
   }

   img->buff->width = img->width;
   img->buff->height = img->height;
   img->buff->buffer = img->data;

   img->buff->offset = (UBYTE **)malloc(img->height * sizeof(UBYTE *));

   if(img->buff->offset == NULL) {
      jlib_exit(jlib_msg(JLIB_EMALLOC));
   }

   /* create line offset array */
   ptr = img->data;
   index = img->buff->offset;
   height = img->height;

   while (height--){
         *index=ptr;
         index++;
         ptr+=img->width;
   }

   JLIB_LEAVE;
}
