/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>


/*+------------------------------------------------------------------------+*/
/*|draw a rect with corners x1, y1 to x2 , y2 in color c without clipping  |*/
/*+------------------------------------------------------------------------+*/
void buff_draw_rectNC (buffer_rec * buff, int x1, int y1, int x2, int y2, UBYTE c)
{
   UBYTE *buffer = B_OFFSET(buff,y1) + x1;
   int width = B_X_SIZE(buff);

   JLIB_ENTER("buff_draw_rectNC");

   x2 = x2 - x1 + 1;
   y2 = y2 - y1 + 1;

   if(x2 < 16){
      for (; y2 > 0; y2--){
        MEM_STORE_SHORT(buffer,c,x2);
        buffer += width;
      }
   }
   else{
      for (; y2 > 0; y2--){
        MEM_STORE_LONG(buffer,c,x2);
        buffer += width;
      }
   }

   JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+*/
/*|draw a rect with corners x1, y1 to x2 , y2 in color c with clipping     |*/
/*+------------------------------------------------------------------------+*/
void buff_draw_rect (buffer_rec * buff, int x1, int y1, int x2, int y2, UBYTE c)
{
   int width,height;

   JLIB_ENTER("buff_draw_rect");

#ifndef JLIB_PRODUCTION
   jlib_check_buffer(buff);
#endif

   if (x1 > x2) {
     JLIB_SWAP(x1,x2);
   }

   if (y1 > y2) {
     JLIB_SWAP(y1,y2);
   }

   width = B_MAX_X(buff);
   height = B_MAX_Y(buff);

   if (x2 > width) {
      x2 = width;
   }
   else{
      if (x2 < 0) {
        JLIB_LEAVE;
        return;
      }
   }

   if (y2 > height) {
      y2 = height;
   }
   else{
      if (y2 < 0) {
        JLIB_LEAVE;
        return;
      }
   }
   
   if (x1 < 0) {
      x1 = 0;
   }
   else{
      if (x1 > width) {
        JLIB_LEAVE;
        return;
      }
   }

   if (y1 < 0) {
      y1 = 0;
   }
   else{
      if (y1 > height) {
        JLIB_LEAVE;
        return;
      }
   }

   buff_draw_rectNC(buff,x1,y1,x2,y2,c);

   JLIB_LEAVE;
}
