/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>

#define ABS(a)   ((a < 0) ? -a : a)
#define SGN(a)   ((a < 0) ? -1 : 1)

/*+-------------------------------------------------------------------------+*/
/*|draw a line from x1, y1 to x2, y2 in color c                             |*/
/*+-------------------------------------------------------------------------+*/
void buff_draw_line(buffer_rec * buff,int x1,int y1,int x2,int y2,UBYTE c)
{
   int max_x,max_y,delta;
   
   JLIB_ENTER("buff_draw_line");

#ifndef JLIB_PRODUCTION
   jlib_check_buffer(buff);
#endif

   max_x = B_MAX_X(buff);
   max_y = B_MAX_Y(buff);

   if(x1 > x2){
     JLIB_SWAP(x1,x2);
     JLIB_SWAP(y1,y2);
   }                    
    
   if((x2 < 0) || (x1 > max_x)){
     JLIB_LEAVE;
     return;
   }
						
   if(y1 < y2){
      if((y2 < 0) || (y1 > max_y)) {            
         JLIB_LEAVE;
	 return;                                                
      }                                                         
      if(y1 < 0) {                                      
	 delta = (x2 - x1)*(0 - y1)/(y2 - y1);  
	 if((x1 += delta) > max_x){
            JLIB_LEAVE;
	    return;
	 }              
	 y1 = 0;                                                
       }                                                                
       if(y2 > max_y) {                                 
	  delta = (x2 - x1)*(y2 - max_y)/(y2 - y1);     

	  if((x2 -= delta) < 0){
             JLIB_LEAVE;
	     return;
	  }             
	  y2 = max_y;                                           
       }                                                                
       if(x1 < 0) {                                     
	  delta = (y2 - y1)*(0 - x1)/(x2 - x1); 
	  y1 += delta;                                                  
	  x1 = 0;                                               
       }                                                                
       if(x2 > max_x) {                                 
	  delta = (y2 - y1)*(x2 - max_x)/(x2 - x1);     
	  y2 -= delta;                                                  
	  x2 = max_x;                                           
       }                                                                
   }                                                                    
   else{                                                                
       if((y1 < 0) || (y2 > max_y)) {           
          JLIB_LEAVE;
	  return;                                               
       }                                                                
       if(y1 > max_y) {                                 
	  delta = (x2 - x1)*(y1 - max_y)/(y1 - y2);     
          if((x1 += delta) > max_x){
             JLIB_LEAVE;
             return;
          }
	  y1 = max_y;                                           
       }                                                                
       if(y2 < 0) {                                     
	  delta = (x2 - x1)*(0 - y2)/(y1 - y2); 
          if((x2 -= delta) < 0){
             JLIB_LEAVE;
             return;
          }
	  y2 = 0;                                               
       }                                                                
       if(x1 < 0) {                                     
	  delta = (y1 - y2)*(0 - x1)/(x2 - x1); 
	  y1 -= delta;                                                  
	  x1 = 0;                                               
       }                                                                
       if(x2 > max_x) {                                 
	  delta = (y1 - y2)*(x2 - max_x)/(x2 - x1);     
	  y2 += delta;                                                  
	  x2 = max_x;                                           
       }                                                                
   }                                                                    

   buff_draw_lineNC(buff,x1,y1,x2,y2,c);

   JLIB_LEAVE;
}


/*+-------------------------------------------------------------------------+*/
/*|draw a line from x1, y1 to x2, y2 in color c                             |*/
/*+-------------------------------------------------------------------------+*/
void buff_draw_lineNC (buffer_rec * buff, int x1, int y1, int x2, int y2, UBYTE c)
{
   int d, x, y, ax, ay, sx, sy, dx, dy;

   JLIB_ENTER("buff_draw_line_NC");

   if (x1 > x2) {
    JLIB_SWAP(x1,x2);
    JLIB_SWAP(y1,y2);
   }

   dx = x2 - x1;
   ax = ABS (dx) << 1;
   sx = SGN (dx);
   dy = y2 - y1;
   ay = ABS (dy) << 1;
   sy = SGN (dy);

   x = x1;
   y = y1;

   if (ax > ay) {
      d = ay - (ax >> 1);
      while (x != x2) {
         *(B_OFFSET(buff,y)+x) = c;
	 if (d >= 0) {
	    y += sy;
	    d -= ax;
	 }
	 x += sx;
	 d += ay;
      }
   }
   else {
      d = ax - (ay >> 1);
      while (y != y2) {
         *(B_OFFSET(buff,y)+x) = c;
	 if (d >= 0) {
	    x += sx;
	    d -= ay;
	 }
	 y += sy;
	 d += ax;
      }
   }
   *(B_OFFSET(buff,y)+x) = c;

   JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+*/
/*|draw a horizontal line from x1, y1 to x2 in color c with clipping       |*/
/*+------------------------------------------------------------------------+*/
void buff_draw_h_line (buffer_rec * buff, int x1, int y1, int x2, UBYTE c)
{
   int width,height;

   JLIB_ENTER("buff_draw_h_line");

#ifndef JLIB_PRODUCTION
   jlib_check_buffer(buff);
#endif

   if (x1 > x2) {
     JLIB_SWAP(x2,x1);
   }

   width = B_MAX_X(buff);
   height = B_MAX_Y(buff);

   if (x2 > width) {
      x2 = width;
   }
   else{
      if (x2 < 0) {
        JLIB_LEAVE;
        return;
      }
   }

   if (x1 < 0) {
      x1 = 0;
   }
   else{
      if (x1 > width) {
        JLIB_LEAVE;
        return;
      }
   }

   if ((y1 < 0) || (y1 > height)) {
      JLIB_LEAVE;
      return;
   }

   buff_draw_h_lineNC(buff,x1,y1,x2,c);

   JLIB_LEAVE;
}

/*+------------------------------------------------------------------------+*/
/*|draw a horizontal line from x1, y1 to x2 in color c without clipping    |*/
/*+------------------------------------------------------------------------+*/
void buff_draw_h_lineNC (buffer_rec * buff, int x1, int y1, int x2, UBYTE c)
{
   UBYTE *buffer = B_OFFSET(buff,y1) + x1;
   int width = x2 - x1 +1;

   JLIB_ENTER("buff_draw_h_line_NC");

   if(width < 17){
      MEM_STORE_SHORT(buffer,c,width);
   }
   else{
      MEM_STORE_LONG(buffer,c,width);
   }

   JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+*/
/*|draw a vertical line from x1, y1 to x2 in color c with clipping         |*/
/*+------------------------------------------------------------------------+*/
void buff_draw_v_line(buffer_rec * buff, int x1, int y1, int y2, UBYTE c)
{
   int height;

   JLIB_ENTER("buff_draw_v_line");

#ifndef JLIB_PRODUCTION
   jlib_check_buffer(buff);
#endif

   if (y1 > y2) {
     JLIB_SWAP(y1,y2);
   }

   height = B_MAX_Y(buff);

   if (y2 > height) {
      y2 = height;
   }
   else{
      if (y2 < 0) {
        JLIB_LEAVE;
        return;
      }
   }

   if (y1 < 0) {
      y1 = 0;
   }
   else{
      if (y1 > height) {
        JLIB_LEAVE;
        return;
      }
   }
   
   if ((x1 < 0) || (x1 > B_MAX_X(buff))) {
      JLIB_LEAVE;
      return;
   }

   buff_draw_v_lineNC(buff,x1,y1,y2,c);

   JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+*/
/*|draw a vertical line from x1, y1 to x2 in color c without clipping      |*/
/*+------------------------------------------------------------------------+*/
void buff_draw_v_lineNC (buffer_rec * buff, int x1, int y1, int y2, UBYTE c)
{
   UBYTE *buffer = B_OFFSET(buff,y1) + x1;
   int width = B_X_SIZE(buff);

   JLIB_ENTER("buff_draw_v_lineNC");

   y2 = y2 - y1 + 1;

   while(y2--){
      *buffer = c;
      buffer += width;
   }

   JLIB_LEAVE;
}
