/*
	Janus demonstration program
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "janus.h"

void prog(void);

void TEST_COLOURS(void);
void TEST_INPUT(void);
void USER_DETAILS(void);

main(int argc, char **argv)
{
	strcpy(program_name,"TEST PROGRAM");

	if (argc > 1)
		j_open_door(argv[1]);
	else
		j_open_door("");
	atexit(j_close_door);          /* call shut_down at exit time        */
	prog();
	return;
}


void prog()
{
	TEST_COLOURS();
	USER_DETAILS();
	TEST_INPUT();
	j_cls();
	j_puts("Thanks for using the Janus test program.\r\n");
	j_puts("The registered libraries don't display the following message....\r\n");
}


void TEST_COLOURS()
{
	/*
		If the caller has ANSI graphics switched off, they will not
		receive the ANSI colour change sequences
	*/

	j_cls();

	j_puts("FIRST AN ANSI COLOUR TEST....\r\n\n");

	j_colour(dkblue);
	j_puts("Dark Blue\r\n");
	j_colour(dkred);
	j_puts("Dark Red\r\n");
	j_colour(dkgreen);
	j_puts("Dark Green\r\n");
	j_colour(magenta);
	j_puts("Magenta\r\n");
	j_colour(brown);
	j_puts("Brown\r\n");
	j_colour(white);
	j_puts("White\r\n");
	j_colour(grey);
	j_puts("Grey\r\n");
	j_colour(yellow);
	j_puts("Yellow\r\n");
	j_colour(dkcyan);
	j_puts("Dark Cyan\r\n");


	j_colour(white);
	j_background(dkblue);
	j_puts("Dark Blue\r\n");
	j_background(dkred);
	j_puts("Dark Red\r\n");
	j_background(dkgreen);
	j_puts("Dark Green\r\n");
	j_background(magenta);
	j_puts("Magenta\r\n");
	j_background(brown);
	j_puts("Brown\r\n");
	j_background(black);
	j_puts("Black\r\n");

	j_colour(black);
	j_background(grey);
	j_puts("Black on grey\r\n");
	j_background(dkcyan);
	j_puts("Black on Dark Cyan\r\n");


	/* Reset colours */
	j_colour(grey);
	j_background(black);

	/* Wait for user to press ENTER */
	j_waitenter();
}

void USER_DETAILS()
{

	j_cls();

	j_puts("A few of the details available about the on-line caller....\r\n\n");

	/* These variables are declared in janus.h */

	j_printf("CALLER:         %s\r\n",username);
	j_printf("LOCATION:       %s\r\n",location);
	j_printf("DATE OF BIRTH:  %s\r\n",(*userdob == 0) ? "<unknown>" : userdob);
	j_printf("TELEPHONE:      %s\r\n",voice_phone);
	j_printf("CONNECT:        %d bps\r\n",baud);
	j_printf("SECURITY:       %d\r\n",seclvl);
	j_printf("UPLOADS:        %ld\r\n",uploads);
	j_printf("DOWNLOADS:      %ld\r\n",downloads);

	j_waitenter();
}


void TEST_INPUT()
{
	char name[100];

	j_cls();

	j_puts("Now we illustrate one of the Janus input functions\r\n\n\n");

	do
	{
		j_puts("\r\nWhat is your name? ");
		strcpy(name,j_input(80,0,0,0,6));

		j_printf("\r\nYour name is \"%s\" is this correct? ",name);
	}
	while(*j_yn() != 'Y');
}