/*************************************************************************
** interpcom-1.1 (command interpreter)                                   **
** unixfic.c : Long filenames in MSDOS                                   **
**                                                                       **
** Copyright (C) 1998  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**									 **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details. 			 **
**									 **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free		 **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France								 **
**                                                                       **
 *************************************************************************/

#include "unixfic.h"
#include <stdio.h>
#include <string.h>
#include <malloc.h>


/*--------------------------------------------------------------------
    Replacement for 'fopen'
--------------------------------------------------------------------*/
FILE* 
Xfopen(char *nom, char *form)
{
    FILE       *S;
    int         n;
    FILE       *t;
    char        h[250],
                h2[250],
                k[250],
                nomfic[250],
                *nom_ms;

    if (nom == NULL)
        return NULL;
    memset(h, 0, 250);    
    memset(h2, 0, 250);
    memset(k, 0, 250);
    memset(nomfic, 0, 250);

    n = 0;
    extrait_info(nom, h, nomfic);

    if (test_nomfic(nomfic) == 1) {
        S = fopen(nom, form);
        if (S != NULL)
            return S;
    }

    strcpy(h2, h);
    strcat(h, NOM_FIC);
    t = fopen(h, "r");
    if (t != NULL) {
        if (cherche_nom(t, nomfic, &nom_ms, &n) != 0) {
            if (n == 0)
                return NULL;
            strcpy(k, h2);
            strcat(k, nom_ms);
            S = fopen(k, form); 
            if (S == NULL) {
               free(nom_ms); 
               fclose(t);
               return NULL;
            } 
            free(nom_ms); 
            fclose(t);
            return S;
        }
        else {
            if (n == -1)
                return NULL;
            sprintf(k, "%s%d%s", h2, n, EXTENS);
            S = fopen(k, form);
            if (S == NULL) 
               return NULL; 
        }
    }
    else {
        sprintf(k, "%s%d%s", h2, n, EXTENS); 
        if (n == -1)
            return NULL;
        S = fopen(k, form);
        if (S == NULL) {
            return NULL;    
        } 
    }

    if (t != NULL) 
        fclose(t);
    t = fopen(h, "a");
    inscrit_fic(t, nomfic); 
    fclose(t);
    return S;
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
void
extrait_info(char *nom, char *nom_dir, char *nom_fic)
{
    int               i,
                      j;
    
    j = 0;
    for (i = 0; i < strlen(nom); i++) 
        if (nom[i] == 47)
            j = i + 1; 
    for (i = 0; i < j; i++)
        nom_dir[i] = nom[i];
    for (i = j ; i < strlen(nom); i++)
        nom_fic[i - j] = nom[i];
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
int 
cherche_nom(FILE *t, char *nomfic, char **nom_ms, int *nb)
{
    int              ind0,
                     j,
                     n;
    char             ch;
    
    rewind(t);
    
    ind0 = 0;             /* ind0 = 0 si les precedents caracteres
                             de la partie UNIX sont bons */
    j = -1;
    n = -1;
    
    while (fread(&ch,1 ,1 ,t) != 0) { 
        if (ch == 0) {
            if (ind0 == 0 && j == strlen(nomfic) - 1)
                break;
            j = -1;
            n++;
            ind0 = 0;
        } 
        else {
            if (ind0 == 0) {
                if (ch != nomfic[j + 1])
                    ind0 = 1;
                else 
                    j++; 
            }
        } 
    }

    if (j != strlen(nomfic) - 1) { 
        nb[0] = n + 1;
        return 0;
    }
    nom_ms[0] = (char*) malloc((size_t)8 * sizeof(char));
    memset(nom_ms[0], 0, 8);
    sprintf(nom_ms[0], "%d%s", n, EXTENS); 
    nb[0] = n + 1;
    return 1; 
} 
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
void
inscrit_fic(FILE *t, char *nom_unix)
{
    char             ch;
    int              i;

    ch = 0;
    fwrite(&ch, 1, 1, t);
    for (i = 0; i < strlen(nom_unix); i++)
         fwrite(&nom_unix[i], 1, 1, t);
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
void
detruit_nomfic(FILE *t, char *nom_unix)
{
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
int
test_nomfic(char *nom)
{
    int             i,
                    k,
                    len,
                    pos_point;

    len = strlen(nom);
    if (len > 12)
        return 0;
    pos_point = -1;

    for (i = 0; i < len; i++) {
        if (nom[i] == 46) {
            if (pos_point >= 0)
                return 0;
            pos_point = i;
        }
    }

    if (pos_point == -1) {
        if (len > 8) 
            return 0;
        else {
            for (i = 0; i < len; i++) {
                k = nom[i];
                if (nom[i] < 0)
                    k += 256;
                if (char_permis[k] == 0)
                    return 0;
            }

            return 1;
        }
    }
    if (pos_point > 8 || len - pos_point > 4)
        return 0;

    for (i = 0; i < pos_point; i++) {
        k = nom[i];
        if (nom[i] < 0)
           k += 256;
        if (char_permis[k] == 0)
            return 0;
    }

    for (i = pos_point + 1; i < len; i++) {
        k = nom[i];
        if (nom[i] < 0)
           k += 256;
        if (char_permis[k] == 0)
            return 0;
    }

    return 1;
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
     Initialisation : fixes which characters are permitted in a
     valid filename (in MSDOS)
--------------------------------------------------------------------*/
void
init_unixfic(void)
{
    int             i;

    for (i = 0; i < 35; i++)
        char_permis[i] = 0;
    for (i = 35; i < 39; i++)
        char_permis[i] = 1;
    char_permis[33] = 1;
    for (i = 39; i < 65; i++)
        char_permis[i] = 0;
    char_permis[40] = 1;
    char_permis[41] = 1;
    char_permis[45] = 1;
    for (i = 48; i <= 57; i++)
        char_permis[i] = 1;
    for (i = 65; i < 91; i++)
        char_permis[i] = 1;
    for (i = 91; i < 97; i++)
        char_permis[i] = 0;
    char_permis[94] = 1;
    char_permis[95] = 1;
    for (i = 97; i < 123; i++)
        char_permis[i] = 1;
    for (i = 123; i < 128; i++)
        char_permis[i] = 0;
    char_permis[123] = 0;
    char_permis[125] = 0;
    for (i = 128; i < 256; i++)
        char_permis[i] = 1;
}
/*------------------------------------------------------------------*/









