/*******************************************************************
* TESTFUNC.C - This file contains all of the test functions used   *
* in the accompanying optimization article in IMC April 1991.      *
*                                                                  *
* There are 4 sets of functions, a through d. By uncommenting one  *
* of the #define statements below you can choose which set of test *
* functions to run. For example, to test testfunc1c() and          *
* testfunc2c(), you would uncomment the line: "#define TEST_C   0" *
*******************************************************************/

//#define TEST_A    0
//#define TEST_B    0
//#define TEST_C    0
//#define TEST_D    0

/*******************************************************************
* These statements generate macros based on the uncommented line   *
* from above.                                                      *
*******************************************************************/
#ifdef TEST_A
#define testfunc1a(v) testfunc1(v)
#define testfunc2a(v) testfunc2(v)
#endif

#ifdef TEST_B
#define testfunc1b(v) testfunc1(v)
#define testfunc2b(v) testfunc2(v)
#endif

#ifdef TEST_C
#define testfunc1c(v) testfunc1(v)
#define testfunc2c(v) testfunc2(v)
#endif

#ifdef TEST_D
#define testfunc1d(v) testfunc1(v)
#define testfunc2d(v) testfunc2(v)
#endif

/*******************************************************************
* These variables are used by several of the test functions.       *
*******************************************************************/
int w, x, y=1, z=3, a=5, b=7, c=11, d=13;

/*******************************************************************
* This empty function is used to determine the standard function   *
* call overhead.                                                   *
*******************************************************************/
void emptyfunc(void)
	{
	}

/*******************************************************************
* The first set of test functions discussed in the article.        *
*******************************************************************/
void testfunc1a(void)
	{
	_asm
		{
		add WORD PTR x,0;
		}
	}

void testfunc2a(void)
	{
	x = x + 0;
	}

/*******************************************************************
* The second set of test functions discussed in the article.       *
*******************************************************************/
void testfunc1b(void)
	{
	_asm
		{
		mov al, 2;
		imul WORD PTR x;
		mov WORD PTR x, ax;
		}
	}

void testfunc2b(void)
	{
	x <<= 1;
	}

/*******************************************************************
* The third set of test functions discussed in the article.        *
*******************************************************************/
void testfunc1c(void)
	{
	x = y + ((a * b) - 1);
	z = ((a * b) - 1) / c;
	}

void testfunc2c(void)
	{
	register int t = (a * b) - 1;

	x = y + t;
	z = t / c;
	}

/*******************************************************************
* The fourth set of test functions discussed in the article.       *
*******************************************************************/
void testfunc1d(void)
	{
	x = y + ((a * b) - 1);
	z = ((a * b) - 1) / c;
	w = ((a * b) - 1) * d;
	}

void testfunc2d(void)
	{
	register int t = (a * b) - 1;

	x = y + t;
	z = t / c;
	w = t * d;
	}

