#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>

#include "getargs.h"

/* user input defined */

#define DEFAULT_STRING "Default String"

int  arg_boolean  = 0;
char arg_char     = 'A';
char arg_string[] = DEFAULT_STRING;
int arg_integer   = 0;

ARGUMENTS arg_settings[] = {
                            {"b", BOOLEAN,   &arg_boolean,  "boolean argument description goes here"},
                            {"c", CHARACTER, &arg_char,     "character argument description goes here"},
                            {"i", INTEGER,   &arg_integer,  "integer argument description goes here"},
                            {"s", STRING,    arg_string,    "string argument description goes here"}};

void ARGUMENT_DEMO(void)
{
    printf("boolean demo          : %-4s\n", arg_boolean == 0 ? "NO" : "YES");
    printf("integer demo          : %-4s value  : %d\n", arg_integer == 0 ? "NO" : "YES", arg_integer);
    printf("string demo           : %-4s string : %s\n", strcmp(DEFAULT_STRING, arg_string)  == 0 ? "NO" : "YES", arg_string);
    printf("char demo             : %-4s char   : %c\n", arg_char  == 'A' ? "NO" : "YES", arg_char);
    puts("");
}


/* comment this and to see the simple version */
#define USED_OPTIONS

int main(int argc, char **argv)
{
    int status;

#ifdef USED_OPTIONS    
    ARG_OPTIONS arg;
    
    arg.option = SHOW_FLAGS | CHAIN_STR;
    status = init_arg(argc, argv, arg_settings, TAB_SIZE, ARG_DASH, &arg);
    if(status != 0)
    {
        printf("ERROR: %s\n", arg_error(status));
        exit(1);
    }

    int index;

    for(index = arg.start; index < arg.end; index++)
    {
        printf("Extra arguments: %s\n", argv[index]);
    }
#else
    status = init_arg(argc, argv, arg_settings, TAB_SIZE, ARG_DASH, 0);
    if(status != 0)
    {
        printf("ERROR: %s\n", arg_error(status));
        exit(1);
    }
#endif

    
    
    ARGUMENT_DEMO();
    return 0;
}
