/************************************************************************/ 
/*                                                                      */ 
/*                      DUMBTERM.C                                      */
/*                                                                      */ 
/*                                                                      */ 
/*   A real stupid terminal program that uses FOSSIL for ALL I/O        */ 
/*                                                                      */ 
/************************************************************************/
/*                                                                      */ 
/*       For now, we will just hard code the port and baud rate.        */ 
/*      You may want to modify this program so that they are            */
/*           specified on the command line.                             */
/*                                                                      */ 
/************************************************************************/ 

#define   PORT 1                   /* 0==COM1, 1==COM2, 2==COM3, etc       */
#define   BAUD 9600           /* Put real baud rate here                   */

int  local_echo=1;            /* Make this zero if the host echos          */
int  ctrl_c_flag=0;           /* Non functional - just an example          */

 void
term(port)
 int port;
{
     int       commchar;
     int       keychar;

     while (1) {

/************************************************************************/ 
/*                                                                      */ 
/*       Now, check the communications port for any received data       */ 
/*                                                                      */ 
/*          If you find one, display it to the screen using ANSI 3.64   */ 
/*                            emulation through the FOSSIL.             */ 
/*                                                                      */ 
/************************************************************************/ 

          if (f_peek(port) != -1) {
               commchar = f_rx(port) & 0x00ff;
               f_wransi(commchar);
               if (commchar == 13)               /* CR => CR/LF translation      
    */
                    f_wransi(10);
          }

/************************************************************************/ 
/*                                                                      */ 
/*           Now, check the keyboard for a character. If one is there,  */ 
/*           and it is not the ESCape key (we exit on the ESCape key),  */ 
/*          transmit it to the FOSSIL function to send it to the remote */ 
/*           system. Also note the CR => CR/LF translation in both the  */
/*                       communications and keyboard handlers.          */ 
/*                                                                      */ 
/************************************************************************/ 

          if (f_keyrdnowait() != -1) {
               keychar = f_keyrd() & 0x00ff;
               if (keychar == 27)
                    return;
               if (local_echo) {
                    f_wransi(keychar);
                    if (keychar == 13)     /* CR => CR/LF translation */
                         f_wransi(10);
               }
               f_tx(port,keychar);
               if (keychar == 13)         /* CR => CR/LF translation */
                    f_tx(port,10);
          }
     }
}

main()
{

/************************************************************************/ 
/*                                                                      */ 
/*           Initialize the FOSSIL and check the return value for the   */ 
/*                      "magic" number which indicates success.         */ 
/*                                                                      */ 
/************************************************************************/ 

     if (f_init(PORT,0,&ctrl_c_flag) != 0x1954) {
          printf("Could not initialize FOSSIL\n");
          exit(0);
     }
     f_baud(PORT,BAUD);
     f_dtr(PORT,1);
     puts("DUMBTERM Ready\n");

/************************************************************************/ 
/*                                                                      */ 
/*                  Throw control to the dumb terminal function.        */ 
/*                                                                      */  
/************************************************************************/ 
     
     term(PORT);

/************************************************************************/ 
/*                                                                      */ 
/*    When we get back, drop the DTR signal and deinitialize the        */ 
/*                                      port we used.                   */ 
/*                                                                      */ 
/************************************************************************/ 

     f_dtr(PORT,0);
     f_deinit(PORT);
}
