/* x.h                    freeware                  xhunga@tiscali.fr  */


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void eq_Tan(
double    c,
double (*P_f)(double x),
double (*PDf)(double x)
)
{
 double a =  (*PDf)(c);
 double b =(-(*PDf)(c)* c + (*P_f)(c));

 printf(" %0.3lf*x %+0.3lf", a, b);
 printf(" = 0");
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gplt_Tan(
double xmin,
double xmax,
double ymin,
double ymax,
double c,
  char    fEQ[TXT_EQ],
double (*P_f)(double x),
double (*PDf)(double x)
)
{
  FILE       *fp;
double a =  (*PDf)(c);
double b =(-(*PDf)(c)* c + (*P_f)(c));

        fp = fopen("f_Df.plt","w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis\n\n");
fprintf(fp," plot [%0.3lf:%0.3lf] [%0.3lf:%0.3lf] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",fEQ);
fprintf(fp,", ");
fprintf(fp," %0.6lf*x %+0.6lf", a, b);
fprintf(fp,"\n\n");
fprintf(fp," reset");

 fclose(fp);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gplt_TanA(
double xmin,
double xmax,
double ymin,
double ymax,
double cmin,
double cmax,
double cstep,
  char    fEQ[TXT_EQ],
double (*P_f)(double x),
double (*PDf)(double x)
)
{
FILE   *fp;
double a;
double b;
double c;

        fp = fopen("f_Df.plt","w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis\n\n");

for(c = cmin; c<cmax; c +=cstep)
{
fprintf(fp," plot [%0.3lf:%0.3lf] [%0.3lf:%0.3lf] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",fEQ);
fprintf(fp,", ");
  a =  (*PDf)(c);
  b =(-(*PDf)(c)* c + (*P_f)(c));
fprintf(fp," %0.6lf*x %+0.6lf", a, b);
fprintf(fp,"\n pause 1\n\n");
}

fprintf(fp," reset");

 fclose(fp);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gplt_Tan_xy(
double xmin,
double xmax,
double ymin,
double ymax,
double c,
  char    fEQ[TXT_EQ],
double (*P_f)(double x),
double (*PDf)(double x)
)
{
double  a;
double  b;
char    FPc[FILENAME] = "P";
char     FA[FILENAME] = "A";
char     FB[FILENAME] = "B";
FILE   *fp;
FILE   *fq;
FILE   *fr;
FILE   *fs;

        fp = fopen("f_Df.plt","w");
        fq = fopen(       FPc,"w");
        fr = fopen(        FA,"w");
        fs = fopen(        FB,"w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis \n\n");
fprintf(fp," plot [%0.3lf:%0.3lf] [%0.3lf:%0.3lf] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",fEQ);
fprintf(fp,", ");

a =  (*PDf)(c);
b =(-(*PDf)(c)* c + (*P_f)(c));
fprintf(fp," %0.6lf*x %+0.6lf", a, b);

fprintf(fp,", ");
fprintf(fp," \"%s\" lt 1 ",FPc);
fprintf(fp,", ");
fprintf(fp," \"%s\" lt 1 ",FA);
fprintf(fp,", ");
fprintf(fp," \"%s\" lt 1 ",FB);
fprintf(fp,"\n\n");
fprintf(fp," reset");

a = ((*P_f)(c));
fprintf(fq," %0.6lf   %0.6lf", c, a);

a = c - ((*P_f)(c)) / ((*PDf)(c));
fprintf(fr," %0.6lf   %0.6lf", a, 0.0);

a = ((*P_f)(c))- (((*PDf)(c) )*c);
fprintf(fs," %0.6lf   %0.6lf", 0.0, a);

 fclose(fp);
 fclose(fq);
 fclose(fr);
 fclose(fs);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gplt_TanPx(
double xmin,
double xmax,
double ymin,
double ymax,
double c,
  char    fEQ[TXT_EQ],
double (*P_f)(double x),
double (*PDf)(double x)
)
{
char    FPX[FILENAME] = "ptoxaxis";
FILE   *fp;
FILE   *ft;
double  a;
double  b;

        fp = fopen("f_Df.plt","w");
        ft = fopen(FPX,       "w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis \n\n");
fprintf(fp," plot [%0.3lf:%0.3lf] [%0.3lf:%0.3lf] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",fEQ);
fprintf(fp,", ");

a =  (*PDf)(c);
b =(-(*PDf)(c)* c + (*P_f)(c));
fprintf(fp," %0.6lf*x %+0.6lf",a, b);

fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 ",FPX);
fprintf(fp,"\n\n");
fprintf(fp," reset");

a =  c;
b = ((*P_f)(c));
fprintf(ft," %0.6lf   %0.6lf\n",  a, b);

a = c- ( ((*P_f)(c)) / ((*PDf)(c)) );
fprintf(ft," %0.6lf   %0.6lf", a, 0.0);

 fclose(fp);
 fclose(ft);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gplt_TanPy(
double xmin,
double xmax,
double ymin,
double ymax,
double   c,
  char    fEQ[TXT_EQ],
double (*P_f)(double x),
double (*PDf)(double x)
)
{
double a;
double b;
double t;

char    FPY[FILENAME]  = "Ptoyaxis";
FILE   *fp;
FILE   *ft;

        fp = fopen("f_Df.plt","w");
        ft = fopen(FPY,  "w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis\n\n");
fprintf(fp," plot [%0.3lf:%0.3lf] [%0.3lf:%0.3lf] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",fEQ);
fprintf(fp,", ");

a = ((*PDf)(c));
b = (-((*PDf)(c))* c + ((*P_f)(c)));
fprintf(fp," %0.6lf*x %+0.6lf", a ,b);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 ",FPY);
fprintf(fp,"\n\n");
fprintf(fp," reset");

t = ((*P_f)(c));
fprintf(ft," %0.6lf   %0.6lf\n", c, t);

t = ((*P_f)(c))-(((*PDf)(c))*c);
fprintf(ft," %0.6lf   %0.6lf", 0., t);

 fclose(fp);
 fclose(ft);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gplt_TanxM(
double xmin,
double xmax,
double ymin,
double ymax,
double c,
  char   fEQ[TXT_EQ],
double (*P_f)(double x),
double (*PDf)(double x)
)
{
double a;
double b;
double t;

char    FPX[FILENAME] = "PX";
char    FAM[FILENAME] = "AM";
FILE   *fp;
FILE   *ft;
FILE   *fr;

        fp = fopen("f_Df.plt","w");
        ft = fopen(FPX,  "w");
        fr = fopen(FAM,  "w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis \n\n");

fprintf(fp," plot [%0.3lf:%0.3lf] [%0.3lf:%0.3lf] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",fEQ);
fprintf(fp,", ");

a =  ((*PDf)(c));
b =(-(*PDf)(c)* c + (*P_f)(c));
fprintf(fp," %0.6lf*x %+0.6lf", a, b);

fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 ",FPX);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 4 ",FAM);
fprintf(fp,"\n\n");
fprintf(fp," reset");

t = ((*P_f)(c));
fprintf(ft," %0.6lf   %0.6lf\n",  c, t);

t = c-(((*P_f)(c))/((*PDf)(c))) ;
fprintf(ft," %0.6lf   %0.6lf", t , 0.);

t = c-(((*P_f)(c))/((*PDf)(c))) ;
fprintf(fr," %0.6lf   %0.6lf\n", t, 0.);
fprintf(fr," %0.6lf   %0.6lf  ", c,  0.);

 fclose(fp);
 fclose(ft);
 fclose(fr);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gplt_TMeanValue(
double xmin,
double xmax,
double ymin,
double ymax,
double   r,
double   s,
double   c,
  char   fEQ[TXT_EQ],
double (*P_f)(double x),
double (*PDf)(double x)
)
{
  FILE *fp;
char    FRS[FILENAME] = "rs";

double  a;
double  b;
double  t;

        fp = fopen("f_Df.plt","w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis\n\n");
fprintf(fp," plot [%0.3lf:%0.3lf] [%0.3lf:%0.3lf] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",fEQ);
fprintf(fp,", ");
                                a =  (*PDf)(c);
                                   b =(-(*PDf)(c)* c + (*P_f)(c));
fprintf(fp," %0.6lf*x %+0.6lf", a, b);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 ",FRS);
fprintf(fp,"\n\n");
fprintf(fp," reset");

             fclose(fp);

        fp = fopen(FRS,  "w");

t = ((*P_f)(r)) ;
fprintf(fp," %0.6lf   %0.6lf\n", r, t);

t = ((*P_f)(s)) ;
fprintf(fp," %0.6lf   %0.6lf  ", s, t);

             fclose(fp);
}

