/*         .c                       freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
double f(
double x)
{
 return(       3.0*x*x  - 2.0*x - 5.0);
}
char  feq[] = "3.0*x**2 - 2.0*x - 5.0";
/* -------------------------------------------------------------------------- */
double Df(
double x)
{
 return(       6.0*x - 2.0);
}
char Dfeq[] = "6.0*x - 2.0";
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */

/* --------------------------------- MAIN ----------------------------------- */
int main(void)
{
double (*Pfunct)     (double x);
double (*PfunctDeriv)(double x);
/*-------------------------------- PROGRAM ---------------------------------- */
 Pfunct      =  f;
 PfunctDeriv = Df;

 clrscrn();
 printf("  f : x-> %s\n\n", feq);
 printf(" Df : x-> %s\n\n",Dfeq);

 printf(" The equation of the tangent is :    Df(a) (x-a) + f(a)\n\n");
 printf(" The equation of the  normal is : -1/Df(a) (x-a) + f(a)\n\n");

     gplt_NormA(-4,      /* xmin  plot [xmin:xmax] [ymin:ymax] */
                 4,      /* xmax  */
                -6,      /* ymin  */
                 4,      /* ymax  */
              -1.5,      /* amin  */
                 2,      /* amax  */
                .2,      /* astep */
               feq,
         (*Pfunct),
         (*PfunctDeriv)
              );

 printf("\n\n To see the result in Gnuplot (gp373w32.exe) :           \n\n");
 printf("  * open the file f_Df.plt with Gnuplot.\n");

 printf("\n Press return to continue");
 getchar();

 return 0;
}

