/*
** The Window BOSS's Data Clerk
** Copyright (c) 1988 - Philip A. Mongelluzzo
** All rights reserved.
**
** wn_gtime - get time from window with gross validation 
**
** Copyright (c) 1988 - Philip A. Mongelluzzo
** All rights reserved.
**
*/

#include "windows.h"                    /* standard stuff */

/*
************
* wn_gtime *
************
*/

/*
** wn_gtime(fun,frm,fld,wn,row,col,prmpt,atrib,fill,hrs,mins,secs,ubuff,hlpmsg,errmsg)
**
**    int        fun - fucntion code (SET || XEQ)
**    (WIFORM)   frm - form pointer  (actual || NFRM)
**    int        fld - field # in form (actual || NFLD)
**    (WINDOWPTR) wn - window pointer
**    int        row - row in window where data input begins
**    int        col - col in window where data input begins
**    (char *) prmpt - field promt (call with NSTR for none)
**    unsigned atrib - field (not prompt) atributes 
**    char      fill - field fill character
**    (int *)    hrs - pointer to int for month (0-24)
**    (int *)   mins - pointer to int for day (0-59)
**    (int *)   secs - pointer to int for year (0-59)
**    (char *) ubuff - pointer to char array of 10 bytes for editing 
**    (char *)hlpmsg - pointer to help message (call with NSTR for none)
**    (char *)errmsg - pointer to err message (call with NSTR) for none)
**
** RETURNS:
**
**    HRS, MINS, and SECS via pointers.
**
**    NULL if error, else the non zero value returned from wn_input.
**
** NOTES:
**
**  FUN -   fun can only be SET for form setup, or XEQ for immediate
**          execution.  When called with SET, valid arguements for both
**          "frm" and "fld" must be specfied.  frm is the field pointer
**          returned from frmopn(), and fld is the field sequence number
**          in the form for this field.  When called with XEQ frm must
**          be NFRM and fld must NFLD.
**
**  UBUFF - Editing buffer.  Must be of sufficent size to hold the
**          data as it is entered.  Typical value is the length
**          of the mask + 2 bytes (strlen(mask)+2).
**
**          On entry, the first byte of ubuff should be 
**          a null, otherwise wn_input assumes there is valid
**          data there and will enter edit mode.  This can be 
**          handy if there is a need for prefilled but editable
**          fields.  In actual pratice, wn_input uses this
**          buffer for both initial character data entry and
**          subsequent editing.
**
**          On return, ubuff contains the actual data entered in
**          character format with fill and mask characters as
**          spaces (e.g. "23 59 22").
**
**  Only basic reasonability checks are made.  Therefore, times like
**  24:59:59 can be returned.
**
**  Calls wn_input to perform data entry.
**
**  Data must satisfy validation checks for function to return.
*/

wn_gtime(fun,frm,fld,wn,row,col,prmpt,atrib,fill,hours,mins,secs,ubuff,hlpmsg,errmsg)
int fun;                                /* SET or XEQ */
WIFORM frm;                             /* form pointer or NFRM */
int fld;                                /* field number or NFLD */
WINDOWPTR wn;                           /* window to use */
int row, col;                           /* position of input field */
char *prmpt;                            /* prompt string */
unsigned atrib;                         /* data entry atribute */
char fill;                              /* fill char */
int *hours, *mins, *secs;               /* hours, mins, secs */
char *ubuff;                            /* returns "hh:mm:ss" */
char *hlpmsg, *errmsg;                  /* help & error messages */
{
int h, m, s;                            /* hours, mins, secs */
char mbuf[10];                          /* local buffer */
char *p;                                /* scratch */
unsigned int r;                         /* sscanf return value */
int rv;                                 /* return value */
int eflg;                               /* error flag */

  if(fun != SET && fun != XEQ)          /* saftey check */
    return(NULL);

  if(fun == SET) {                      /* set up */
    if(frm[fld]->pself != (char *)frm[fld])
      wns_ierr("wn_gtime");             /* die if memory is mangled */
    frm[fld]->wn = wn;                  /* set window */
    frm[fld]->row = row;                /* set row */
    frm[fld]->col = col;                /* set col */
    frm[fld]->prmpt = prmpt;            /* set prompt */
    frm[fld]->atrib = atrib;            /* set attribute */
    frm[fld]->fill = fill;              /* set fill character */
    frm[fld]->fcode = GTIME;            /* function code */
    frm[fld]->v1.vip = hours;           /* &hours */
    frm[fld]->v2.vip = mins;            /* &mins */
    frm[fld]->v3.vip = secs;            /* &secs */
    frm[fld]->v4.vcp = ubuff;           /* &ubuff */
    frm[fld]->v5.vcp = hlpmsg;          /* &hlpmsg */
    frm[fld]->v6.vcp = errmsg;          /* &errmsg */
    return(TRUE);
  }

begin:
  if(!(rv=wn_input(wn,row,col,prmpt,"##:##:##",fill,atrib,ubuff,hlpmsg))) {
    *ubuff = NUL;                       /* load ubuff with a bad time */
    return(NULL);                       /* indicate error */
  }
  if(wni_frmflg) return(TRUE);          /* wn_frmget in progress */
  if(wns_escape) return(rv);            /* escape pressed ?? */
  strcpy(mbuf,ubuff);                   /* load my buffer */
  p = mbuf;                             /* set pointer */
  while (*p) {                          /* set up to pluck */
    if(*p == ':')                       /* the colon */
      *p = ' ';                         /* and stash a space */
    p++;                                /* bump pointer */
  }                                     /* continue till done */
  r =  sscanf(mbuf, "%02d %02d %02d", &h, &m, &s);
  if(r == EOF || r == 0) {              /* no data */
    *hours = *mins = *secs = 0;         /* set em all to zip */
    return(rv);                         /* and return */
  }
  eflg = FALSE;
  if(r != 3) eflg = TRUE;               /* not enuf data */
  if(h < 0 || h > 24) eflg = TRUE;      /* bad hour */
  if(m < 0 || m > 59) eflg = TRUE;      /* bad min */
  if(s < 0 || s > 59) eflg = TRUE;      /* bad sec */
  if(eflg) {                            /* error ? */
    wn_iemsg(errmsg);                   /* do error thing */
    goto begin;                         /* and start over */
  }
  *hours = h;                           /* load user hours */
  *mins = m;                            /* and mins */
  *secs = s;                            /* and seconds */
  return(rv);                           /* all is well.. in gross sense */
}

/* End */

