/*==========================================================================
 *
 *  !BEST005.C                                     Wednesday, April 20, 1994
 *
 *  Linked List Functions
 *  supplementary source file 5 for The BESTLibrary
 *
 *  Authored independently by George Vanous
 *
 *==========================================================================*/


/* ------------------------------------------------------------------------ */
/* ----------------------------  INCLUDE FILES  --------------------------- */

#include <alloc.h>
#include "!bestlib.h"                  // include !BESTLIB.H in compilation

/* ------------------------------------------------------------------------ */

/*----------------------------------------------------------------------------
 * Search for a node in a linked list.
 *
 * "node" - node to search for
 * "list" - linked list to search through
 *
 * RETURNS:
 * = node of linked list
 * = NULL if node not found in linked list
 */
llist *lst_find(llist *node, llist *list)
{
  while (list != node && list);     // while there is no match and a next node
    list = list->next;              //  hop to next node

  return(list);                     // return "node" of linked list, else NULL
}

/*----------------------------------------------------------------------------
 * Deallocate all of the nodes of a singly-linked list.
 *
 * "list" - singly linked list to deallocate
 *
 * RETURNS:
 * = NULL
 */
llist_single *lst_free_single(llist_single *list)
{
  llist_single *tail;                  // tail of linked list

  while (list->next) {
    /* get to the node that is just before the tail end of the linked list */
    for (tail = list; tail->next->next; tail = tail->next);
    free(tail->next);                  // deallocate tail of linked list
    tail->next = NULL;                 // define new tail of linked list
  }
  free(list);                          // deallocate head of linked list
  return(NULL);
}

/*----------------------------------------------------------------------------
 * Deallocate all of the nodes of a doubly-linked list.
 *
 * "list" - doubly linked list to deallocate
 *
 * RETURNS:
 * = NULL
 */
llist_double *lst_free_double(llist_double *list)
{
  llist_double *tail;                  // tail of linked list

  tail = (llist_double *)lst_tail( (llist *)list); // get to tail
  while (list->next) {
    tail = tail->prev;                 // go to previous node of linked list
    free(tail->next);                  // deallocate node we just came from
    tail->next = NULL;                 // define new tail of linked list
  }
  free(list);                          // deallocate head of linked list
  return(NULL);
}

/*----------------------------------------------------------------------------
 * Return the tail of a linked list.
 *
 * "list" - linked list to return the tail of
 *
 * RETURNS:
 * = tail of linked list
 */
llist *lst_tail(llist *list)
{
  if (!list) return( NULL );           // empty linked list

  while (list->next)                   // while there is a next node
    list = list->next;                 //  hop to next node

  return(list);                        // return tail of linked list
}

/*----------------------------------------------------------------------------
 * Unlink a node from a doubly linked list.
 *
 * "head"   - pointer to first node of linked list
 * "unlink" - node to unlink
 *
 * RETURNS:
 * = next available node
 * = NULL if linked list is empty
 */
llist_double *lst_unlink_double(llist_double **head, llist_double *unlink)
{
  llist_double *next;                  // next node of linked list

  next = unlink->next;                 // next node

  if (!unlink->prev) {
    /* unlink the first node */
    *head = next;
    if (next) next->prev = NULL;       // new beginning of linked list
  }
  else {
    unlink->prev->next = next;         // unlink node "unlink"
    if (next) next->prev = unlink->prev;
  }

  free(unlink);                        // deallocate this node
  return( next );
}

/*----------------------------------------------------------------------------
 * Unlink a node from a singly linked list.
 *
 * "head"   - pointer to first node of linked list
 * "unlink" - node to unlink
 *
 * RETURNS:
 * = next available node
 * = NULL if linked list is empty
 */
llist_single *lst_unlink_single(llist_single **head, llist_single *unlink)
{
  llist_single *next, *prev;           // next/previous nodes of linked list

  next = unlink->next;                 // next node of linked list

  if (*head == unlink) {
    /* unlink the first node */
    *head = next;                      // new beginning of linked list
  }
  else {
    for (prev = *head; prev->next != unlink; prev = prev->next);
    prev->next = next;                 // unlink node "unlink"
  }

  free(unlink);                        // deallocate this node
  return( next );
}

/*==============================  END-OF-FILE  =============================*/